"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateNotesById = exports.initialAppState = exports.appReducer = void 0;
var _typescriptFsaReducers = require("typescript-fsa-reducers");
var _actions = require("./actions");
var _experimental_features = require("../../../../common/experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialAppState = {
  notesById: {},
  errors: [],
  enableExperimental: {
    ..._experimental_features.allowedExperimentalValues
  }
};
exports.initialAppState = initialAppState;
const updateNotesById = ({
  note,
  notesById
}) => ({
  ...notesById,
  [note.id]: note
});
exports.updateNotesById = updateNotesById;
const appReducer = (0, _typescriptFsaReducers.reducerWithInitialState)(initialAppState).case(_actions.addNotes, (state, {
  notes
}) => ({
  ...state,
  notesById: notes.reduce((acc, note) => ({
    ...acc,
    [note.id]: note
  }), {})
})).case(_actions.deleteNote, (state, {
  id
}) => ({
  ...state,
  notesById: Object.fromEntries(Object.entries(state.notesById).filter(([_, note]) => {
    return note.id !== id && note.saveObjectId !== id;
  }))
})).case(_actions.updateNote, (state, {
  note
}) => ({
  ...state,
  notesById: updateNotesById({
    note,
    notesById: state.notesById
  })
})).case(_actions.addError, (state, {
  id,
  title,
  message
}) => ({
  ...state,
  errors: state.errors.concat({
    id,
    title,
    message
  })
})).case(_actions.removeError, (state, {
  id
}) => ({
  ...state,
  errors: state.errors.filter(error => error.id !== id)
})).case(_actions.addErrorHash, (state, {
  id,
  hash,
  title,
  message
}) => {
  const errorIdx = state.errors.findIndex(e => e.id === id);
  const errorObj = state.errors.find(e => e.id === id) || {
    id,
    title,
    message
  };
  if (errorIdx === -1) {
    return {
      ...state,
      errors: state.errors.concat({
        ...errorObj,
        hash,
        displayError: !state.errors.some(e => e.hash === hash)
      })
    };
  }
  return {
    ...state,
    errors: [...state.errors.slice(0, errorIdx), {
      ...errorObj,
      hash,
      displayError: !state.errors.some(e => e.hash === hash)
    }, ...state.errors.slice(errorIdx + 1)]
  };
}).build();
exports.appReducer = appReducer;