"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAlertsTableConfiguration = void 0;
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _use_trigger_actions_browser_fields_options = require("../../../detections/hooks/trigger_actions_alert_table/use_trigger_actions_browser_fields_options");
var _use_cell_actions = require("../../../detections/hooks/trigger_actions_alert_table/use_cell_actions");
var _use_bulk_actions = require("../../../detections/hooks/trigger_actions_alert_table/use_bulk_actions");
var _use_actions_column = require("../../../detections/hooks/trigger_actions_alert_table/use_actions_column");
var _use_persistent_controls = require("../../../detections/hooks/trigger_actions_alert_table/use_persistent_controls");
var _constants = require("../../../../common/constants");
var _local_storage = require("../../../timelines/containers/local_storage");
var _security_solution_detections = require("../../../detections/configurations/security_solution_detections");
var _render_cell_value = require("../../../detections/configurations/security_solution_detections/render_cell_value");
var _flyout = require("../../../timelines/components/side_panel/event_details/flyout");
var _model = require("../../store/sourcerer/model");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerAlertsTableConfiguration = (registry, storage) => {
  var _dataTableStorage$Tab, _dataTableStorage$Tab2;
  const dataTableStorage = (0, _local_storage.getDataTablesInStorageByIds)(storage, [_securitysolutionDataTable.TableId.alertsOnAlertsPage]);
  const columnsFormStorage = (_dataTableStorage$Tab = dataTableStorage === null || dataTableStorage === void 0 ? void 0 : (_dataTableStorage$Tab2 = dataTableStorage[_securitysolutionDataTable.TableId.alertsOnAlertsPage]) === null || _dataTableStorage$Tab2 === void 0 ? void 0 : _dataTableStorage$Tab2.columns) !== null && _dataTableStorage$Tab !== void 0 ? _dataTableStorage$Tab : [];
  const alertColumns = columnsFormStorage.length ? columnsFormStorage : (0, _security_solution_detections.getColumns)();
  const useInternalFlyout = () => {
    const {
      header,
      body,
      footer
    } = (0, _flyout.useToGetInternalFlyout)();
    return {
      header,
      body,
      footer
    };
  };
  const renderCellValueHookAlertPage = (0, _render_cell_value.getRenderCellValueHook)({
    scopeId: _model.SourcererScopeName.detections,
    tableId: _securitysolutionDataTable.TableId.alertsOnAlertsPage
  });
  const renderCellValueHookCasePage = (0, _render_cell_value.getRenderCellValueHook)({
    scopeId: _model.SourcererScopeName.detections,
    tableId: _securitysolutionDataTable.TableId.alertsOnCasePage
  });
  const sort = [{
    '@timestamp': {
      order: 'desc'
    }
  }];

  // register Alert Table on Alert Page
  registerIfNotAlready(registry, {
    id: _constants.ALERTS_TABLE_REGISTRY_CONFIG_IDS.ALERTS_PAGE,
    cases: {
      featureId: _constants.CASES_FEATURE_ID,
      owner: [_constants.APP_ID],
      syncAlerts: true
    },
    columns: alertColumns,
    getRenderCellValue: renderCellValueHookAlertPage,
    useActionsColumn: (0, _use_actions_column.getUseActionColumnHook)(_securitysolutionDataTable.TableId.alertsOnAlertsPage),
    useInternalFlyout,
    useBulkActions: (0, _use_bulk_actions.getBulkActionHook)(_securitysolutionDataTable.TableId.alertsOnAlertsPage),
    useCellActions: (0, _use_cell_actions.getUseCellActionsHook)(_securitysolutionDataTable.TableId.alertsOnAlertsPage),
    usePersistentControls: (0, _use_persistent_controls.getPersistentControlsHook)(_securitysolutionDataTable.TableId.alertsOnAlertsPage),
    sort,
    useFieldBrowserOptions: (0, _use_trigger_actions_browser_fields_options.getUseTriggersActionsFieldBrowserOptions)(_model.SourcererScopeName.detections),
    showInspectButton: true
  });

  // register Alert Table on RuleDetails Page
  registerIfNotAlready(registry, {
    id: _constants.ALERTS_TABLE_REGISTRY_CONFIG_IDS.RULE_DETAILS,
    cases: {
      featureId: _constants.CASES_FEATURE_ID,
      owner: [_constants.APP_ID],
      syncAlerts: true
    },
    columns: alertColumns,
    getRenderCellValue: renderCellValueHookAlertPage,
    useActionsColumn: (0, _use_actions_column.getUseActionColumnHook)(_securitysolutionDataTable.TableId.alertsOnRuleDetailsPage),
    useInternalFlyout,
    useBulkActions: (0, _use_bulk_actions.getBulkActionHook)(_securitysolutionDataTable.TableId.alertsOnRuleDetailsPage),
    useCellActions: (0, _use_cell_actions.getUseCellActionsHook)(_securitysolutionDataTable.TableId.alertsOnRuleDetailsPage),
    usePersistentControls: (0, _use_persistent_controls.getPersistentControlsHook)(_securitysolutionDataTable.TableId.alertsOnRuleDetailsPage),
    sort,
    useFieldBrowserOptions: (0, _use_trigger_actions_browser_fields_options.getUseTriggersActionsFieldBrowserOptions)(_model.SourcererScopeName.detections),
    showInspectButton: true
  });
  registerIfNotAlready(registry, {
    id: _constants.ALERTS_TABLE_REGISTRY_CONFIG_IDS.CASE,
    cases: {
      featureId: _constants.CASES_FEATURE_ID,
      owner: [_constants.APP_ID],
      syncAlerts: true
    },
    columns: alertColumns,
    getRenderCellValue: renderCellValueHookCasePage,
    useInternalFlyout,
    useBulkActions: (0, _use_bulk_actions.getBulkActionHook)(_securitysolutionDataTable.TableId.alertsOnCasePage),
    useCellActions: (0, _use_cell_actions.getUseCellActionsHook)(_securitysolutionDataTable.TableId.alertsOnCasePage),
    sort,
    showInspectButton: true
  });
};
exports.registerAlertsTableConfiguration = registerAlertsTableConfiguration;
const registerIfNotAlready = (registry, registryArgs) => {
  if (!registry.has(registryArgs.id)) {
    registry.register(registryArgs);
  }
};