"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSourcererDataView = void 0;
var _sourcerer = require("../../../../common/utils/sourcerer");
var _use_data_view = require("../source/use_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSourcererDataView = async (dataViewId, dataViewsService, refreshFields = false) => {
  var _dataViewData$id, _dataViewData$id2;
  const dataView = await dataViewsService.get(dataViewId, true, refreshFields);
  const dataViewData = dataView.toSpec();
  const defaultPatternsList = (0, _sourcerer.ensurePatternFormat)(dataView.getIndexPattern().split(','));

  // typeguard used to assert that pattern is a string, otherwise
  // typescript expects patternList to be (string | null)[]
  // but we want it to always be string[]
  const filterTypeGuard = str => str != null;
  const patternList = await Promise.all(defaultPatternsList.map(async pattern => {
    try {
      var _dataViewData$typeMet, _dataViewData$typeMet2;
      await dataViewsService.getFieldsForWildcard({
        type: dataViewData.type,
        rollupIndex: dataViewData === null || dataViewData === void 0 ? void 0 : (_dataViewData$typeMet = dataViewData.typeMeta) === null || _dataViewData$typeMet === void 0 ? void 0 : (_dataViewData$typeMet2 = _dataViewData$typeMet.params) === null || _dataViewData$typeMet2 === void 0 ? void 0 : _dataViewData$typeMet2.rollup_index,
        allowNoIndex: false,
        pattern
      });
      return pattern;
    } catch {
      return null;
    }
  })).then(allPatterns => allPatterns.filter(pattern => filterTypeGuard(pattern))).catch(() => defaultPatternsList);
  return {
    loading: false,
    id: (_dataViewData$id = dataViewData.id) !== null && _dataViewData$id !== void 0 ? _dataViewData$id : '',
    title: dataView.getIndexPattern(),
    indexFields: dataView.fields,
    fields: dataViewData.fields,
    patternList,
    dataView: dataViewData,
    browserFields: (0, _use_data_view.getDataViewStateFromIndexFields)((_dataViewData$id2 = dataViewData.id) !== null && _dataViewData$id2 !== void 0 ? _dataViewData$id2 : '', dataViewData.fields).browserFields,
    runtimeMappings: dataViewData.runtimeFieldMap
  };
};
exports.getSourcererDataView = getSourcererDataView;