"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomaliesQueryTabBody = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../common/constants");
var _utils = require("./utils");
var _use_installed_security_jobs = require("../../../components/ml/hooks/use_installed_security_jobs");
var _kibana = require("../../../lib/kibana");
var _matrix_histogram = require("../../../components/matrix_histogram");
var _histogram_configs = require("./histogram_configs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ID = 'anomaliesHistogramQuery';
const AnomaliesQueryTabBodyComponent = ({
  deleteQuery,
  endDate,
  setQuery,
  skip,
  startDate,
  type,
  filterQuery,
  anomaliesFilterQuery,
  AnomaliesTableComponent,
  flowTarget,
  ip,
  hostName,
  userName,
  indexNames
}) => {
  const {
    jobs
  } = (0, _use_installed_security_jobs.useInstalledSecurityJobs)();
  const [anomalyScore] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_ANOMALY_SCORE);
  const mergedFilterQuery = (0, _utils.getAnomaliesFilterQuery)(filterQuery, anomaliesFilterQuery, jobs, anomalyScore, flowTarget, ip);
  (0, _react.useEffect)(() => {
    return () => {
      if (deleteQuery) {
        deleteQuery({
          id: ID
        });
      }
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_matrix_histogram.MatrixHistogram, (0, _extends2.default)({
    endDate: endDate,
    filterQuery: mergedFilterQuery,
    id: ID,
    indexNames: indexNames,
    setQuery: setQuery,
    startDate: startDate
  }, _histogram_configs.histogramConfigs)), /*#__PURE__*/_react.default.createElement(AnomaliesTableComponent, {
    startDate: startDate,
    endDate: endDate,
    skip: skip,
    type: type,
    flowTarget: flowTarget,
    ip: ip,
    hostName: hostName,
    userName: userName
  }));
};
AnomaliesQueryTabBodyComponent.displayName = 'AnomaliesQueryTabBodyComponent';
const AnomaliesQueryTabBody = /*#__PURE__*/_react.default.memo(AnomaliesQueryTabBodyComponent);
exports.AnomaliesQueryTabBody = AnomaliesQueryTabBody;
AnomaliesQueryTabBody.displayName = 'AnomaliesQueryTabBody';