"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensEmbeddable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/embeddable-plugin/public");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _actions = require("../../store/inputs/actions");
var _kibana = require("../../lib/kibana");
var _use_lens_attributes = require("./use_lens_attributes");
var _use_actions = require("./use_actions");
var _store = require("../../store");
var _use_selector = require("../../hooks/use_selector");
var _modal = require("../inspect/modal");
var _constants = require("../../store/inputs/constants");
var _utils = require("./utils");
var _model = require("../../store/sourcerer/model");
var _actions2 = require("./actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOVER_ACTIONS_PADDING = 24;
const LensComponentWrapper = _styledComponents.default.div`
  height: ${({
  $height
}) => $height ? `${$height}px` : 'auto'};
  width: ${({
  width
}) => width !== null && width !== void 0 ? width : 'auto'};

  ${({
  $addHoverActionsPadding
}) => $addHoverActionsPadding ? `.embPanel__header--floater { top: ${HOVER_ACTIONS_PADDING * -1}px; }` : ''}

  .expExpressionRenderer__expression {
    padding: 2px 0 0 0 !important;
  }
  .legacyMtrVis__container {
    padding: 0;
  }
`;
const initVisualizationData = {
  requests: undefined,
  responses: undefined,
  isLoading: true
};
const LensEmbeddableComponent = ({
  applyGlobalQueriesAndFilters = true,
  extraActions,
  extraOptions,
  getLensAttributes,
  height: wrapperHeight,
  id,
  inputsModelId = _constants.InputsModelId.global,
  inspectTitle,
  lensAttributes,
  onLoad,
  scopeId = _model.SourcererScopeName.default,
  stackByField,
  timerange,
  width: wrapperWidth,
  withActions = true
}) => {
  var _attributes$state, _attributes$state$vis, _attributes$state4, _visualizationData$re3;
  const style = (0, _react.useMemo)(() => ({
    height: wrapperHeight !== null && wrapperHeight !== void 0 ? wrapperHeight : '100%',
    minWidth: '100px',
    width: wrapperWidth !== null && wrapperWidth !== void 0 ? wrapperWidth : '100%'
  }), [wrapperHeight, wrapperWidth]);
  const {
    lens,
    data: {
      actions: {
        createFiltersFromValueClickAction
      }
    }
  } = (0, _kibana.useKibana)().services;
  const dispatch = (0, _reactRedux.useDispatch)();
  const [isShowingModal, setIsShowingModal] = (0, _react.useState)(false);
  const [visualizationData, setVisualizationData] = (0, _react.useState)(initVisualizationData);
  const getGlobalQuery = _store.inputsSelectors.globalQueryByIdSelector();
  const {
    searchSessionId
  } = (0, _use_selector.useDeepEqualSelector)(state => getGlobalQuery(state, id));
  const attributes = (0, _use_lens_attributes.useLensAttributes)({
    applyGlobalQueriesAndFilters,
    extraOptions,
    getLensAttributes,
    lensAttributes,
    scopeId,
    stackByField,
    title: ''
  });
  const preferredSeriesType = attributes === null || attributes === void 0 ? void 0 : (_attributes$state = attributes.state) === null || _attributes$state === void 0 ? void 0 : (_attributes$state$vis = _attributes$state.visualization) === null || _attributes$state$vis === void 0 ? void 0 : _attributes$state$vis.preferredSeriesType;
  // Avoid hover actions button overlaps with its chart
  const addHoverActionsPadding = (attributes === null || attributes === void 0 ? void 0 : attributes.visualizationType) !== 'lnsLegacyMetric' && (attributes === null || attributes === void 0 ? void 0 : attributes.visualizationType) !== 'lnsPie';
  const LensComponent = lens.EmbeddableComponent;
  const inspectActionProps = (0, _react.useMemo)(() => ({
    onInspectActionClicked: () => {
      setIsShowingModal(true);
    },
    isDisabled: visualizationData.isLoading
  }), [visualizationData.isLoading]);
  const actions = (0, _use_actions.useActions)({
    attributes,
    extraActions,
    inspectActionProps,
    timeRange: timerange,
    withActions
  });
  const handleCloseModal = (0, _react.useCallback)(() => {
    setIsShowingModal(false);
  }, []);
  const updateDateRange = (0, _react.useCallback)(({
    range
  }) => {
    const [min, max] = range;
    dispatch((0, _actions.setAbsoluteRangeDatePicker)({
      id: inputsModelId,
      from: new Date(min).toISOString(),
      to: new Date(max).toISOString()
    }));
  }, [dispatch, inputsModelId]);
  const requests = (0, _react.useMemo)(() => {
    var _visualizationData$re;
    const [request, ...additionalRequests] = (_visualizationData$re = visualizationData.requests) !== null && _visualizationData$re !== void 0 ? _visualizationData$re : [];
    return {
      request,
      additionalRequests
    };
  }, [visualizationData.requests]);
  const responses = (0, _react.useMemo)(() => {
    var _visualizationData$re2;
    const [response, ...additionalResponses] = (_visualizationData$re2 = visualizationData.responses) !== null && _visualizationData$re2 !== void 0 ? _visualizationData$re2 : [];
    return {
      response,
      additionalResponses
    };
  }, [visualizationData.responses]);
  const onLoadCallback = (0, _react.useCallback)((isLoading, adapters) => {
    var _adapters$requests;
    if (!adapters) {
      return;
    }
    const data = (0, _utils.getRequestsAndResponses)(adapters === null || adapters === void 0 ? void 0 : (_adapters$requests = adapters.requests) === null || _adapters$requests === void 0 ? void 0 : _adapters$requests.getRequests());
    setVisualizationData({
      requests: data.requests,
      responses: data.responses,
      isLoading
    });
    if (onLoad != null) {
      onLoad({
        requests: data.requests,
        responses: data.responses,
        isLoading
      });
    }
  }, [onLoad]);
  const onFilterCallback = (0, _react.useCallback)(async e => {
    if (!Array.isArray(e.data) || preferredSeriesType !== 'area') {
      return;
    }
    // Update timerange when clicking on a dot in an area chart
    const [{
      query
    }] = await createFiltersFromValueClickAction({
      data: e.data,
      negate: e.negate
    });
    const rangeFilter = query === null || query === void 0 ? void 0 : query.range['@timestamp'];
    if (rangeFilter !== null && rangeFilter !== void 0 && rangeFilter.gte && rangeFilter !== null && rangeFilter !== void 0 && rangeFilter.lt) {
      updateDateRange({
        range: [rangeFilter.gte, rangeFilter.lt]
      });
    }
  }, [createFiltersFromValueClickAction, updateDateRange, preferredSeriesType]);
  const adHocDataViews = (0, _react.useMemo)(() => {
    var _attributes$state2, _attributes$state3;
    return (attributes === null || attributes === void 0 ? void 0 : (_attributes$state2 = attributes.state) === null || _attributes$state2 === void 0 ? void 0 : _attributes$state2.adHocDataViews) != null ? Object.values(attributes === null || attributes === void 0 ? void 0 : (_attributes$state3 = attributes.state) === null || _attributes$state3 === void 0 ? void 0 : _attributes$state3.adHocDataViews).reduce((acc, adHocDataView) => {
      if ((adHocDataView === null || adHocDataView === void 0 ? void 0 : adHocDataView.name) != null) {
        acc.push(adHocDataView === null || adHocDataView === void 0 ? void 0 : adHocDataView.name);
      }
      return acc;
    }, []) : null;
  }, [attributes === null || attributes === void 0 ? void 0 : (_attributes$state4 = attributes.state) === null || _attributes$state4 === void 0 ? void 0 : _attributes$state4.adHocDataViews]);
  if (!searchSessionId) {
    return null;
  }
  if (!attributes || (visualizationData === null || visualizationData === void 0 ? void 0 : visualizationData.responses) != null && (visualizationData === null || visualizationData === void 0 ? void 0 : (_visualizationData$re3 = visualizationData.responses) === null || _visualizationData$re3 === void 0 ? void 0 : _visualizationData$re3.length) === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.lensEmbeddable.NoDataToDisplay.title",
        defaultMessage: "No data to display"
      }))
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_actions2.VisualizationActions, {
      extraActions: extraActions,
      getLensAttributes: getLensAttributes,
      inputId: inputsModelId,
      isInspectButtonDisabled: true,
      lensAttributes: attributes,
      queryId: id,
      stackByField: stackByField,
      timerange: timerange,
      title: inspectTitle,
      withDefaultActions: false
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, attributes && searchSessionId && /*#__PURE__*/_react.default.createElement(LensComponentWrapper, {
    $height: wrapperHeight,
    width: wrapperWidth,
    $addHoverActionsPadding: addHoverActionsPadding
  }, /*#__PURE__*/_react.default.createElement(LensComponent, {
    id: id,
    style: style,
    timeRange: timerange,
    attributes: attributes,
    onLoad: onLoadCallback,
    onBrushEnd: updateDateRange,
    onFilter: onFilterCallback,
    viewMode: _public.ViewMode.VIEW,
    withDefaultActions: false,
    extraActions: actions,
    searchSessionId: searchSessionId,
    showInspector: false,
    syncTooltips: false,
    syncCursor: false
  })), isShowingModal && requests.request != null && responses.response != null && /*#__PURE__*/_react.default.createElement(_modal.ModalInspectQuery, {
    adHocDataViews: adHocDataViews,
    additionalRequests: requests.additionalRequests,
    additionalResponses: responses.additionalResponses,
    closeModal: handleCloseModal,
    "data-test-subj": "inspect-modal",
    inputId: inputsModelId,
    request: requests.request,
    response: responses.response,
    title: inspectTitle
  }));
};
const LensEmbeddable = /*#__PURE__*/_react.default.memo(LensEmbeddableComponent);
exports.LensEmbeddable = LensEmbeddable;