"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BarText = exports.BarSpacer = exports.BarSection = exports.BarGroup = exports.BarAction = exports.Bar = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Bar = _styledComponents.default.aside.attrs({
  className: 'siemUtilityBar'
})`
  ${({
  border,
  theme
}) => (0, _styledComponents.css)`
    ${border && (0, _styledComponents.css)`
      border-bottom: ${theme.eui.euiBorderThin};
      padding-bottom: ${theme.eui.euiSizeXS};
      align-items: center;
    `}

    @media only screen and (min-width: ${theme.eui.euiBreakpoints.l}) {
      display: flex;
      justify-content: space-between;
    }
  `}
`;
exports.Bar = Bar;
Bar.displayName = 'Bar';
const BarSection = _styledComponents.default.div.attrs({
  className: 'siemUtilityBar__section'
})`
  ${({
  grow,
  theme
}) => (0, _styledComponents.css)`
    & + & {
      margin-top: ${theme.eui.euiSizeS};
      align-items: center;
    }

    @media only screen and (min-width: ${theme.eui.euiBreakpoints.m}) {
      display: flex;
      flex-wrap: wrap;
    }

    @media only screen and (min-width: ${theme.eui.euiBreakpoints.l}) {
      & + & {
        margin-top: 0;
        margin-left: ${theme.eui.euiSize};
      }
    }
    ${grow && (0, _styledComponents.css)`
      flex: 1;
    `}
  `}
`;
exports.BarSection = BarSection;
BarSection.displayName = 'BarSection';
const BarGroup = _styledComponents.default.div.attrs({
  className: 'siemUtilityBar__group'
})`
  ${({
  grow,
  theme
}) => (0, _styledComponents.css)`
    align-items: flex-start;
    display: flex;
    flex-wrap: wrap;

    & + & {
      margin-top: ${theme.eui.euiSizeS};
    }

    @media only screen and (min-width: ${theme.eui.euiBreakpoints.m}) {
      border-right: ${theme.eui.euiBorderThin};
      flex-wrap: nowrap;
      margin-right: ${theme.eui.euiSizeM};
      padding-right: ${theme.eui.euiSizeM};

      & + & {
        margin-top: 0;
      }

      &:last-child {
        border-right: none;
        margin-right: 0;
        padding-right: 0;
      }
    }

    & > * {
      margin-right: ${theme.eui.euiSize};

      &:last-child {
        margin-right: 0;
      }
    }
    ${grow && (0, _styledComponents.css)`
      flex: 1;
    `}
  `}
`;
exports.BarGroup = BarGroup;
BarGroup.displayName = 'BarGroup';
const BarText = _styledComponents.default.p.attrs(({
  className
}) => ({
  className: className || 'siemUtilityBar__text'
}))`
  ${({
  shouldWrap,
  theme
}) => (0, _styledComponents.css)`
    color: ${theme.eui.euiTextSubduedColor};
    font-size: ${theme.eui.euiFontSizeXS};
    line-height: ${theme.eui.euiLineHeight};
    white-space: ${shouldWrap ? 'normal' : 'nowrap'};
  `}
`;
exports.BarText = BarText;
BarText.displayName = 'BarText';
const BarAction = _styledComponents.default.div.attrs({
  className: 'siemUtilityBar__action'
})`
  ${({
  theme
}) => (0, _styledComponents.css)`
    font-size: ${theme.eui.euiFontSizeXS};
  `}
`;
exports.BarAction = BarAction;
BarAction.displayName = 'BarAction';
const BarSpacer = _styledComponents.default.div.attrs({
  className: 'siemUtilityBar__spacer'
})`
  ${() => (0, _styledComponents.css)`
    flex: 1;
  `}
`;
exports.BarSpacer = BarSpacer;
BarSpacer.displayName = 'BarSpacer';