"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRowItemsWithActions = exports.RowItemOverflowComponent = exports.RowItemOverflow = exports.Popover = exports.OverflowFieldComponent = exports.OverflowField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _cell_actions = require("../cell_actions");
var _helpers = require("../drag_and_drop/helpers");
var _empty_value = require("../empty_value");
var _page = require("../page");
var _field_renderers = require("../../../timelines/components/field_renderers/field_renderers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Subtext = _styledComponents.default.div`
  font-size: ${props => props.theme.eui.euiFontSizeXS};
`;
const getRowItemsWithActions = ({
  values,
  fieldName,
  fieldType = 'keyword',
  idPrefix,
  render,
  displayCount = 5,
  maxOverflow = 5,
  aggregatable
}) => {
  if (values != null && values.length > 0) {
    const visibleItems = values.slice(0, displayCount).map((value, index) => {
      const id = (0, _helpers.escapeDataProviderId)(`${idPrefix}-${fieldName}-${value}-${index}`);
      return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
        key: id,
        mode: _cell_actions.CellActionsMode.HOVER_DOWN,
        visibleCellActions: 5,
        showActionTooltips: true,
        triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
        field: {
          name: fieldName,
          value,
          type: fieldType,
          aggregatable
        }
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, render ? render(value) : (0, _empty_value.defaultToEmptyTag)(value)));
    });
    return visibleItems.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, visibleItems, ' ', /*#__PURE__*/_react.default.createElement(RowItemOverflow, {
      fieldName: fieldName,
      values: values,
      fieldType: fieldType,
      idPrefix: idPrefix,
      maxOverflowItems: maxOverflow,
      overflowIndexStart: displayCount,
      isAggregatable: aggregatable
    })) : (0, _empty_value.getEmptyTagValue)();
  } else {
    return (0, _empty_value.getEmptyTagValue)();
  }
};
exports.getRowItemsWithActions = getRowItemsWithActions;
const RowItemOverflowComponent = ({
  fieldName,
  values,
  fieldType,
  isAggregatable,
  idPrefix,
  maxOverflowItems = 5,
  overflowIndexStart = 5
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, values.length > overflowIndexStart && /*#__PURE__*/_react.default.createElement(Popover, {
    count: values.length - overflowIndexStart,
    idPrefix: idPrefix
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_field_renderers.MoreContainer, {
    fieldName: fieldName,
    idPrefix: idPrefix,
    isAggregatable: isAggregatable,
    fieldType: fieldType,
    values: values,
    overflowIndexStart: overflowIndexStart,
    moreMaxHeight: "none"
  }), values.length > overflowIndexStart + maxOverflowItems && /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "popover-additional-overflow"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, values.length - overflowIndexStart - maxOverflowItems, ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.tables.rowItemHelper.moreDescription",
    defaultMessage: "more not shown"
  }))))));
};
exports.RowItemOverflowComponent = RowItemOverflowComponent;
RowItemOverflowComponent.displayName = 'RowItemOverflowComponent';
const RowItemOverflow = /*#__PURE__*/_react.default.memo(RowItemOverflowComponent);
exports.RowItemOverflow = RowItemOverflow;
const PopoverComponent = ({
  children,
  count,
  idPrefix
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => {
    setIsOpen(!isOpen);
  }, [isOpen]);
  return /*#__PURE__*/_react.default.createElement(Subtext, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: onButtonClick,
      "data-test-subj": "overflow-button"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.tables.rowItemHelper.overflowButtonDescription",
      defaultMessage: "+{count} More",
      values: {
        count
      }
    })),
    closePopover: () => setIsOpen(!isOpen),
    id: `${idPrefix}-popover`,
    isOpen: isOpen,
    panelClassName: "withHoverActions__popover",
    repositionOnScroll: true
  }, children));
};
PopoverComponent.displayName = 'PopoverComponent';
const Popover = /*#__PURE__*/_react.default.memo(PopoverComponent);
exports.Popover = Popover;
Popover.displayName = 'Popover';
const OverflowFieldComponent = ({
  value,
  showToolTip = true,
  overflowLength = 50
}) => /*#__PURE__*/_react.default.createElement("span", null, showToolTip ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  "data-test-subj": 'message-tooltip',
  content: 'message'
}, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value.substring(0, overflowLength))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value.substring(0, overflowLength)), value.length > overflowLength && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: value
}, /*#__PURE__*/_react.default.createElement(_page.MoreRowItems, {
  type: "boxesHorizontal"
})));
exports.OverflowFieldComponent = OverflowFieldComponent;
OverflowFieldComponent.displayName = 'OverflowFieldComponent';
const OverflowField = /*#__PURE__*/_react.default.memo(OverflowFieldComponent);
exports.OverflowField = OverflowField;
OverflowField.displayName = 'OverflowField';