"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobSwitchComponent = exports.JobSwitch = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _helpers = require("../../../../../common/machine_learning/helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StaticSwitch = (0, _styledComponents.default)(_eui.EuiSwitch)`
  .euiSwitch__thumb,
  .euiSwitch__icon {
    transition: none;
  }
`;
StaticSwitch.displayName = 'StaticSwitch';
const JobSwitchComponent = ({
  job,
  isSecurityJobsLoading,
  onJobStateChange
}) => {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const handleChange = (0, _react.useCallback)(async e => {
    setIsLoading(true);
    await onJobStateChange(job, job.latestTimestampMs || 0, e.target.checked);
    setIsLoading(false);
  }, [job, setIsLoading, onJobStateChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isSecurityJobsLoading || isLoading || (0, _helpers.isJobLoading)(job.jobState, job.datafeedState) ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    "data-test-subj": "job-switch-loader"
  }) : /*#__PURE__*/_react.default.createElement(StaticSwitch, {
    "data-test-subj": "job-switch",
    disabled: (0, _helpers.isJobFailed)(job.jobState, job.datafeedState),
    checked: (0, _helpers.isJobStarted)(job.jobState, job.datafeedState),
    onChange: handleChange,
    showLabel: false,
    label: ""
  })));
};
exports.JobSwitchComponent = JobSwitchComponent;
JobSwitchComponent.displayName = 'JobSwitchComponent';
const JobSwitch = /*#__PURE__*/_react.default.memo(JobSwitchComponent);
exports.JobSwitch = JobSwitch;
JobSwitch.displayName = 'JobSwitch';