"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobIdFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JobIdFilter = ({
  selectedJobIds,
  onSelect,
  title,
  jobIds,
  jobNameById
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(!isPopoverOpen);
  }, [isPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const updateSelection = (0, _react.useCallback)(selectedJobId => {
    const currentSelection = selectedJobIds !== null && selectedJobIds !== void 0 ? selectedJobIds : [];
    const newSelection = currentSelection.includes(selectedJobId) ? currentSelection.filter(s => s !== selectedJobId) : [...currentSelection, selectedJobId];
    onSelect(newSelection);
  }, [selectedJobIds, onSelect]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    disabled: jobIds.length === 0,
    "data-test-subj": "job-id-filter-button",
    hasActiveFilters: selectedJobIds.length > 0,
    iconType: "arrowDown",
    isSelected: isPopoverOpen,
    numActiveFilters: selectedJobIds.length,
    onClick: onButtonClick,
    contentProps: {
      style: {
        minWidth: 112
      }
    } // avoid resizing when selecting job id
  }, title), [jobIds.length, selectedJobIds.length, isPopoverOpen, onButtonClick, title]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "euiFilterSelect__items"
  }, jobIds.map(id => {
    var _jobNameById$id;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
      "data-test-subj": `job-id-filter-item-${id}`,
      checked: selectedJobIds.includes(id) ? 'on' : undefined,
      key: id,
      onClick: () => updateSelection(id)
    }, (_jobNameById$id = jobNameById[id]) !== null && _jobNameById$id !== void 0 ? _jobNameById$id : id);
  }))));
};
exports.JobIdFilter = JobIdFilter;