"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnomaliesDefaultTableColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _entity = require("../entity");
var _create_compound_key = require("./create_compound_key");
var i18n = _interopRequireWildcard(require("./translations"));
var _get_entries = require("../get_entries");
var _score = require("../score/score");
var _create_explorer_link = require("../links/create_explorer_link");
var _formatted_date = require("../../formatted_date");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAnomaliesDefaultTableColumns = (startDate, endDate) => [{
  name: i18n.DETECTOR,
  field: 'jobName',
  sortable: true,
  render: (jobName, anomalyBy) => /*#__PURE__*/_react.default.createElement(_create_explorer_link.ExplorerLink, {
    score: anomalyBy.anomaly,
    startDate: startDate,
    endDate: endDate,
    linkName: jobName
  })
}, {
  name: i18n.SCORE,
  field: 'anomaly.severity',
  sortable: true,
  render: (_, anomalyBy) => /*#__PURE__*/_react.default.createElement(_score.Score, {
    score: anomalyBy.anomaly
  })
}, {
  name: i18n.ENTITY,
  field: 'anomaly.entityValue',
  sortable: true,
  render: (entityValue, anomalyBy) => /*#__PURE__*/_react.default.createElement(_entity.Entity, {
    entityName: anomalyBy.anomaly.entityName,
    entityValue: entityValue
  })
}, {
  name: i18n.INFLUENCED_BY,
  field: 'anomaly.influencers',
  render: (influencers, anomalyBy) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false
  }, influencers && influencers.map(influencer => {
    const [key, value] = (0, _get_entries.getEntries)(influencer);
    const entityName = key != null ? key : '';
    const entityValue = value != null ? value : '';
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: `${entityName}-${entityValue}-${(0, _create_compound_key.createCompoundAnomalyKey)(anomalyBy.anomaly)}`,
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_entity.Entity, {
      entityName: entityName,
      entityValue: entityValue
    }))));
  }))
}, {
  name: i18n.TIME_STAMP,
  field: 'anomaly.time',
  sortable: true,
  render: time => /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
    value: time
  })
}];
exports.getAnomaliesDefaultTableColumns = getAnomaliesDefaultTableColumns;