"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCustomChartData = exports.getBarchartConfigs = exports.formatToChartDataItem = exports.defaultLegendColors = exports.DEFAULT_Y_TICK_FORMATTER = exports.DEFAULT_CHART_HEIGHT = void 0;
var _charts = require("@elastic/charts");
var _fp = require("lodash/fp");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_CHART_HEIGHT = 174;
exports.DEFAULT_CHART_HEIGHT = DEFAULT_CHART_HEIGHT;
const DEFAULT_Y_TICK_FORMATTER = value => value.toLocaleString();
exports.DEFAULT_Y_TICK_FORMATTER = DEFAULT_Y_TICK_FORMATTER;
const getBarchartConfigs = ({
  chartHeight,
  from,
  legendPosition,
  to,
  onBrushEnd,
  yTickFormatter,
  showLegend
}) => ({
  series: {
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    stackAccessors: ['g']
  },
  axis: {
    xTickFormatter: (0, _utils.histogramDateTimeFormatter)([from, to]),
    yTickFormatter: yTickFormatter != null ? yTickFormatter : DEFAULT_Y_TICK_FORMATTER,
    tickSize: 8
  },
  settings: {
    legendPosition: legendPosition !== null && legendPosition !== void 0 ? legendPosition : _charts.Position.Right,
    onBrushEnd,
    showLegend: showLegend !== null && showLegend !== void 0 ? showLegend : true,
    showLegendExtra: true,
    theme: {
      scales: {
        barsPadding: 0.08
      },
      chartMargins: {
        left: 0,
        right: 0,
        top: 0,
        bottom: 0
      },
      chartPaddings: {
        left: 0,
        right: 0,
        top: 0,
        bottom: 0
      }
    }
  },
  customHeight: chartHeight !== null && chartHeight !== void 0 ? chartHeight : DEFAULT_CHART_HEIGHT
});
exports.getBarchartConfigs = getBarchartConfigs;
const defaultLegendColors = ['#1EA593', '#2B70F7', '#CE0060', '#38007E', '#FCA5D3', '#F37020', '#E49E29', '#B0916F', '#7B000B', '#34130C', '#GGGGGG'];
exports.defaultLegendColors = defaultLegendColors;
const formatToChartDataItem = ([key, value]) => ({
  key,
  value
});
exports.formatToChartDataItem = formatToChartDataItem;
const getCustomChartData = (data, mapping) => {
  if (!data) return [];
  const dataGroupedByEvent = (0, _fp.groupBy)('g', data);
  const dataGroupedEntries = (0, _fp.toPairs)(dataGroupedByEvent);
  const formattedChartData = (0, _fp.map)(formatToChartDataItem, dataGroupedEntries);
  return formattedChartData.map((item, idx) => {
    var _mapItem$color;
    const mapItem = (0, _fp.get)(item.key, mapping);
    return {
      ...item,
      color: (_mapItem$color = mapItem === null || mapItem === void 0 ? void 0 : mapItem.color) !== null && _mapItem$color !== void 0 ? _mapItem$color : defaultLegendColors[idx]
    };
  });
};
exports.getCustomChartData = getCustomChartData;