"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderer = exports.plugin = exports.parser = exports.insightPrefix = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react2 = require("@emotion/react");
var _public = require("@kbn/data-views-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _esQuery = require("@kbn/es-query");
var _reactHookForm = require("react-hook-form");
var _use_app_toasts = require("../../../../hooks/use_app_toasts");
var _kibana = require("../../../../lib/kibana");
var _use_insight_query = require("./use_insight_query");
var _use_insight_data_providers = require("./use_insight_data_providers");
var _investigation_guide_view = require("../../../event_details/investigation_guide_view");
var _investigate_in_timeline_button = require("../../../event_details/table/investigate_in_timeline_button");
var _default_date_settings = require("../../../../utils/default_date_settings");
var _constants = require("../../../../../../common/constants");
var _sourcerer = require("../../../../containers/sourcerer");
var _model = require("../../../../store/sourcerer/model");
var _provider = require("./provider");
var _use_license = require("../../../../hooks/use_license");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const insightPrefix = '!{investigate';
exports.insightPrefix = insightPrefix;
const parser = function () {
  const Parser = this.Parser;
  const tokenizers = Parser.prototype.inlineTokenizers;
  const methods = Parser.prototype.inlineMethods;
  const tokenizeInsight = function (eat, value, silent) {
    if (value.startsWith(insightPrefix) === false) {
      return false;
    }
    const nextChar = value[insightPrefix.length];
    if (nextChar !== '{' && nextChar !== '}') return false;
    if (silent) {
      return true;
    }

    // is there a configuration?
    const hasConfiguration = nextChar === '{';
    let configuration = {};
    if (hasConfiguration) {
      let configurationString = '';
      let openObjects = 0;
      for (let i = insightPrefix.length; i < value.length; i++) {
        const char = value[i];
        if (char === '{') {
          openObjects++;
          configurationString += char;
        } else if (char === '}') {
          openObjects--;
          if (openObjects === -1) {
            break;
          }
          configurationString += char;
        } else {
          configurationString += char;
        }
      }
      try {
        configuration = JSON.parse(configurationString);
        return eat(value)({
          type: 'insight',
          ...configuration,
          providers: JSON.stringify(configuration.providers)
        });
      } catch (err) {
        const now = eat.now();
        this.file.fail(i18n.INVALID_FILTER_ERROR(err), {
          line: now.line,
          column: now.column + insightPrefix.length
        });
      }
    }
    return false;
  };
  tokenizeInsight.locator = (value, fromIndex) => {
    return value.indexOf(insightPrefix, fromIndex);
  };
  tokenizers.insight = tokenizeInsight;
  methods.splice(methods.indexOf('text'), 0, 'insight');
};
exports.parser = parser;
const resultFormat = '0,0.[000]a';
const LicensedInsightComponent = ({
  label,
  description,
  providers,
  relativeFrom,
  relativeTo
}) => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  let parsedProviders = [];
  try {
    if (providers !== undefined) {
      parsedProviders = JSON.parse(providers);
    }
  } catch (err) {
    addError(err, {
      title: i18n.PARSE_ERROR
    });
  }
  const {
    data: alertData,
    timestamp
  } = (0, _react.useContext)(_investigation_guide_view.BasicAlertDataContext);
  const {
    dataProviders,
    filters
  } = (0, _use_insight_data_providers.useInsightDataProviders)({
    providers: parsedProviders,
    alertData
  });
  const relativeTimerange = (0, _react.useMemo)(() => {
    if (relativeFrom && relativeTo) {
      const alertRelativeDate = timestamp ? (0, _moment.default)(timestamp) : (0, _moment.default)();
      const from = (0, _default_date_settings.parseDateWithDefault)(relativeFrom, _default_date_settings.DEFAULT_FROM_MOMENT, false, _moment.default, alertRelativeDate.toDate()).toISOString();
      const to = (0, _default_date_settings.parseDateWithDefault)(relativeTo, _default_date_settings.DEFAULT_TO_MOMENT, true, _moment.default, alertRelativeDate.toDate()).toISOString();
      return {
        kind: 'absolute',
        from,
        to
      };
    } else {
      return null;
    }
  }, [relativeFrom, relativeTo, timestamp]);
  const {
    totalCount,
    isQueryLoading,
    oldestTimestamp,
    hasError
  } = (0, _use_insight_query.useInsightQuery)({
    dataProviders,
    filters,
    relativeTimerange
  });
  const timerange = (0, _react.useMemo)(() => {
    if (relativeTimerange) {
      return relativeTimerange;
    } else if (oldestTimestamp != null) {
      return {
        kind: 'absolute',
        from: oldestTimestamp,
        to: new Date().toISOString()
      };
    } else {
      const {
        to,
        from,
        fromStr,
        toStr
      } = (0, _default_date_settings.getTimeRangeSettings)();
      return {
        kind: 'relative',
        to,
        from,
        fromStr,
        toStr
      };
    }
  }, [oldestTimestamp, relativeTimerange]);
  if (isQueryLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_investigate_in_timeline_button.InvestigateInTimelineButton, {
      asEmptyButton: false,
      isDisabled: hasError,
      dataProviders: dataProviders,
      filters: filters,
      timeRange: timerange,
      keepDataView: true,
      "data-test-subj": "insight-investigate-in-timeline-button"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "timeline"
    }), ` ${label} (${(0, _numeral.default)(totalCount).format(resultFormat)})`), /*#__PURE__*/_react.default.createElement("div", null, description));
  }
};

// receives the configuration from the parser and renders
const InsightComponent = ({
  label,
  description,
  providers,
  relativeFrom,
  relativeTo
}) => {
  const isPlatinum = (0, _use_license.useLicense)().isPlatinumPlus();
  if (isPlatinum === false) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isDisabled: true,
      iconSide: 'left',
      iconType: 'timeline',
      "data-test-subj": "insight-investigate-in-timeline-button"
    }, `${label}`), /*#__PURE__*/_react.default.createElement("div", null, description));
  } else {
    return /*#__PURE__*/_react.default.createElement(LicensedInsightComponent, {
      label: label,
      description: description,
      providers: providers,
      relativeFrom: relativeFrom,
      relativeTo: relativeTo
    });
  }
};
exports.renderer = InsightComponent;
const InsightEditorComponent = ({
  node,
  onSave,
  onCancel
}) => {
  const isEditMode = node != null;
  const {
    sourcererDataView,
    indexPattern
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.default);
  const {
    unifiedSearch: {
      ui: {
        FiltersBuilderLazy
      }
    },
    uiSettings,
    fieldFormats
  } = (0, _kibana.useKibana)().services;
  const dataView = (0, _react.useMemo)(() => {
    if (sourcererDataView != null) {
      return new _public.DataView({
        spec: sourcererDataView,
        fieldFormats
      });
    } else {
      return null;
    }
  }, [sourcererDataView, fieldFormats]);
  const [providers, setProviders] = (0, _react.useState)([[]]);
  const dateRangeChoices = (0, _react.useMemo)(() => {
    const settings = uiSettings.get(_constants.DEFAULT_TIMEPICKER_QUICK_RANGES);
    const emptyValue = {
      value: '0',
      text: ''
    };
    return [emptyValue, ...settings.map(({
      display
    }, index) => {
      return {
        value: String(index),
        text: display
      };
    })];
  }, [uiSettings]);
  const formMethods = (0, _reactHookForm.useForm)({
    defaultValues: {
      label: node === null || node === void 0 ? void 0 : node.label,
      description: node === null || node === void 0 ? void 0 : node.description,
      relativeTimerange: (node === null || node === void 0 ? void 0 : node.relativeTimerange) || '0'
    },
    shouldUnregister: true
  });
  const labelController = (0, _reactHookForm.useController)({
    name: 'label',
    control: formMethods.control
  });
  const descriptionController = (0, _reactHookForm.useController)({
    name: 'description',
    control: formMethods.control
  });
  const relativeTimerangeController = (0, _reactHookForm.useController)({
    name: 'relativeTimerange',
    control: formMethods.control
  });
  const getTimeRangeSelection = (0, _react.useCallback)(selection => {
    const selectedOption = dateRangeChoices.find(option => {
      return option.value === selection;
    });
    if (selectedOption && selectedOption.value !== '0') {
      const settingsIndex = Number(selectedOption.value);
      const settings = uiSettings.get(_constants.DEFAULT_TIMEPICKER_QUICK_RANGES);
      return {
        relativeFrom: settings[settingsIndex].from,
        relativeTo: settings[settingsIndex].to
      };
    } else {
      return {};
    }
  }, [dateRangeChoices, uiSettings]);
  const onSubmit = (0, _react.useCallback)(() => {
    onSave(`${insightPrefix}${JSON.stringify((0, _lodash.pickBy)({
      label: labelController.field.value,
      description: descriptionController.field.value,
      providers,
      ...getTimeRangeSelection(relativeTimerangeController.field.value)
    }, value => !(0, _lodash.isEmpty)(value)))}}`, {
      block: true
    });
  }, [onSave, providers, labelController.field.value, descriptionController.field.value, relativeTimerangeController.field.value, getTimeRangeSelection]);
  const onChange = (0, _react.useCallback)(filters => {
    setProviders((0, _provider.filtersToInsightProviders)(filters));
  }, []);
  const selectOnChange = (0, _react.useCallback)(event => {
    relativeTimerangeController.field.onChange(event.target.value);
  }, [relativeTimerangeController.field]);
  const disableSubmit = (0, _react.useMemo)(() => {
    var _labelController$fiel;
    const labelOrEmpty = (_labelController$fiel = labelController.field.value) !== null && _labelController$fiel !== void 0 ? _labelController$fiel : '';
    const flattenedProviders = providers.flat();
    return labelOrEmpty.trim() === '' || flattenedProviders.length === 0 || flattenedProviders.some(provider => !(0, _helpers.isProviderValid)(provider, dataView === null || dataView === void 0 ? void 0 : dataView.getFieldByName(provider.field)));
  }, [labelController.field.value, providers, dataView]);
  const filtersStub = (0, _react.useMemo)(() => {
    const index = indexPattern && indexPattern.getName ? indexPattern.getName() : '*';
    return [{
      $state: {
        store: _esQuery.FilterStateStore.APP_STATE
      },
      meta: {
        disabled: false,
        negate: false,
        alias: null,
        index
      }
    }];
  }, [indexPattern]);
  const isPlatinum = (0, _use_license.useLicense)().isAtLeast('platinum');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    css: (0, _react2.css)`
          min-width: 700px;
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 's'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isEditMode ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.markdown.insight.editModalTitle",
    defaultMessage: "Edit investigation query"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.markdown.insight.addModalTitle",
    defaultMessage: "Add investigation query"
  }))))), isPlatinum === false && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: "To add suggested queries to an investigation guide, please upgrade to platinum",
    iconType: "timeline"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, formMethods, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.FORM_DESCRIPTION,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.LABEL,
    helpText: i18n.LABEL_TEXT,
    isInvalid: labelController.field.value !== undefined && labelController.field.value.trim().length === 0,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, formMethods.register('label'), {
    ref: null,
    name: "label",
    onChange: labelController.field.onChange
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.DESCRIPTION,
    helpText: i18n.DESCRIPTION_TEXT,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, formMethods.register('description'), {
    ref: null,
    name: "description",
    onChange: descriptionController.field.onChange
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.FILTER_BUILDER,
    helpText: i18n.FILTER_BUILDER_TEXT,
    fullWidth: true
  }, dataView ? /*#__PURE__*/_react.default.createElement(FiltersBuilderLazy, {
    filters: filtersStub,
    onChange: onChange,
    dataView: dataView,
    maxDepth: 2
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.RELATIVE_TIMERANGE,
    helpText: i18n.RELATIVE_TIMERANGE_TEXT,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({}, formMethods.register('relativeTimerange'), {
    ref: null,
    onChange: selectOnChange,
    options: dateRangeChoices
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel
  }, i18n.CANCEL_FORM_BUTTON), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: formMethods.handleSubmit(onSubmit),
    fill: true,
    disabled: disableSubmit
  }, isEditMode ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.markdown.insight.addModalConfirmButtonLabel",
    defaultMessage: "Add query"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.markdown.insight.editModalConfirmButtonLabel",
    defaultMessage: "Save changes"
  }))));
};
const InsightEditor = /*#__PURE__*/_react.default.memo(InsightEditorComponent);
const exampleInsight = `${insightPrefix}{
  "label": "Test action",
  "description": "Click to investigate",
  "providers": [
    [
      {"field": "event.id", "value": "{{kibana.alert.original_event.id}}", "queryType": "phrase", "excluded": "false"}
    ],
    [
      {"field": "event.action", "value": "", "queryType": "exists", "excluded": "false"},
      {"field": "process.pid", "value": "{{process.pid}}", "queryType": "phrase", "excluded":"false"}
    ]
  ]
}}`;
const plugin = ({
  licenseIsPlatinum
}) => {
  return {
    name: 'insights',
    button: {
      label: licenseIsPlatinum ? i18n.INVESTIGATE : i18n.INIGHT_UPSELL,
      iconType: 'timelineWithArrow',
      isDisabled: !licenseIsPlatinum
    },
    helpText: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "md",
      fontSize: "l",
      paddingSize: "s",
      isCopyable: true
    }, exampleInsight), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    })),
    editor: InsightEditor
  };
};
exports.plugin = plugin;