"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Loader = void 0;
var _eui = require("@elastic/eui");
var _polished = require("polished");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Aside = _styledComponents.default.aside`
  padding: ${({
  theme
}) => theme.eui.euiSizeM};

  ${({
  overlay,
  overlayBackground,
  theme
}) => overlay && (0, _styledComponents.css)`
      background: ${overlayBackground ? (0, _polished.rgba)(overlayBackground, 0.9) : (0, _polished.rgba)(theme.eui.euiColorEmptyShade, 0.9)};
      bottom: 0;
      left: 0;
      position: absolute;
      right: 0;
      top: 0;
      z-index: ${theme.eui.euiZLevel1};
    `}
`;
Aside.displayName = 'Aside';
const FlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup).attrs(() => ({
  alignItems: 'center',
  direction: 'column',
  gutterSize: 's',
  justifyContent: 'center'
}))`
  ${({
  overlay
}) => overlay && (0, _styledComponents.css)`
      height: 100%;
    `}
`;
FlexGroup.displayName = 'FlexGroup';
const Loader = /*#__PURE__*/_react.default.memo(({
  children,
  overlay,
  overlayBackground,
  size
}) => /*#__PURE__*/_react.default.createElement(Aside, {
  overlay: overlay,
  overlayBackground: overlayBackground
}, /*#__PURE__*/_react.default.createElement(FlexGroup, {
  overlay: {
    overlay
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
  "data-test-subj": "loading-spinner",
  size: size
})), children && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "subdued",
  size: "s"
}, /*#__PURE__*/_react.default.createElement("p", null, children))))));
exports.Loader = Loader;
Loader.displayName = 'Loader';