"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showToasterMessage = exports.formatError = void 0;
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatError = (i18nFailedDetailedMessage, importResponse, errors) => {
  const formattedErrors = errors.map(e => i18nFailedDetailedMessage(e.error.message));
  const error = new Error(formattedErrors.join('. '));
  error.stack = undefined;
  error.name = 'Network errors';
  error.raw_network_error = importResponse;
  return error;
};
exports.formatError = formatError;
const mapErrorMessageToUserMessage = actionConnectorsErrors => {
  let concatenatedActionIds = '';
  const mappedErrors = actionConnectorsErrors.map(connectorError => {
    // Using "as ImportResponseError" because the "id" field belongs only to
    // "ImportResponseError" and if the connectorError has the id we use it to get the
    // number of failing connectors by spliting the unique the connectors ids.
    const {
      id,
      error
    } = connectorError;
    concatenatedActionIds = concatenatedActionIds && concatenatedActionIds !== id ? `${concatenatedActionIds},${id}` : id;
    const {
      status_code: statusCode,
      message: originalMessage
    } = error || {};
    let message;
    switch (statusCode) {
      case 403:
        message = i18n.ACTION_CONNECTORS_ADDITIONAL_PRIVILEGES;
        break;
      default:
        message = originalMessage;
        break;
    }
    return {
      ...connectorError,
      error: {
        ...error,
        message
      }
    };
  });
  const actionIds = new Set(concatenatedActionIds && [...concatenatedActionIds.split(',')]);
  return {
    mappedErrors,
    numberOfActions: actionIds.size
  };
};
const showToasterMessage = ({
  importResponse,
  exceptionsIncluded,
  actionConnectorsIncluded,
  successMessage,
  errorMessage,
  errorMessageDetailed,
  addError,
  addSuccess
}) => {
  if (importResponse.success) {
    if (importResponse.success_count > 0) addSuccess(successMessage(importResponse.success_count));
    if (exceptionsIncluded && importResponse.exceptions_success && importResponse.exceptions_success_count != null && importResponse.exceptions_success_count > 0) {
      addSuccess(i18n.SUCCESSFULLY_IMPORTED_EXCEPTIONS(importResponse.exceptions_success_count));
    }
    if (actionConnectorsIncluded && importResponse.action_connectors_success && importResponse.action_connectors_success_count != null && importResponse.action_connectors_success_count > 0) {
      addSuccess(i18n.SUCCESSFULLY_IMPORTED_CONNECTORS(importResponse.action_connectors_success_count));
    }
    return;
  }
  if (importResponse.errors.length > 0) {
    if (actionConnectorsIncluded && importResponse.action_connectors_errors != null && importResponse.action_connectors_errors.length > 0) {
      const {
        mappedErrors: userErrorMessages,
        numberOfActions
      } = mapErrorMessageToUserMessage(importResponse.action_connectors_errors);
      const connectorError = formatError(errorMessageDetailed, importResponse, userErrorMessages);
      return addError(connectorError, {
        title: i18n.IMPORT_CONNECTORS_FAILED(numberOfActions || userErrorMessages.length)
      });
    }
    const ruleError = formatError(errorMessageDetailed, importResponse, importResponse.errors);
    addError(ruleError, {
      title: errorMessage(importResponse.errors.length)
    });
    if (exceptionsIncluded && importResponse.exceptions_errors != null && importResponse.exceptions_errors.length > 0) {
      const exceptionError = formatError(errorMessageDetailed, importResponse, importResponse.exceptions_errors);
      addError(exceptionError, {
        title: i18n.IMPORT_FAILED(importResponse.exceptions_errors.length)
      });
    }
  }
};
exports.showToasterMessage = showToasterMessage;