"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFilterGroupInternalContext = void 0;
var _react = require("react");
var _filter_group_context = require("../filter_group_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFilterGroupInternalContext = () => {
  const filterContext = (0, _react.useContext)(_filter_group_context.FilterGroupContext);
  if (!filterContext) {
    throw new Error('FilterContext should only be used inside FilterGroup Wrapper');
  }
  return filterContext;
};
exports.useFilterGroupInternalContext = useFilterGroupInternalContext;