"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldValueCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _helpers = require("../../tables/helpers");
var _formatted_field = require("../../../../timelines/components/timeline/body/renderers/formatted_field");
var _constants = require("../../../../timelines/components/timeline/body/renderers/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldValueCell = /*#__PURE__*/_react.default.memo(({
  contextId,
  data,
  eventId,
  fieldFromBrowserField,
  getLinkValue,
  isDraggable = false,
  linkValue,
  style,
  values
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    "data-test-subj": `event-field-${data.field}`,
    direction: "column",
    gutterSize: "none",
    style: style
  }, values != null && values.map((value, i) => {
    var _ref;
    if (fieldFromBrowserField == null) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: `${i}-${value}`
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        key: `${i}-${value}`
      }, value));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "eventFieldsTable__fieldValue",
      grow: false,
      key: `${i}-${value}`
    }, data.field === _constants.MESSAGE_FIELD_NAME ? /*#__PURE__*/_react.default.createElement(_helpers.OverflowField, {
      value: value
    }) : /*#__PURE__*/_react.default.createElement(_formatted_field.FormattedFieldValue, {
      contextId: `${contextId}-${eventId}-${data.field}-${i}-${value}`,
      eventId: eventId,
      fieldFormat: data.format,
      fieldName: data.field,
      fieldType: data.type,
      isAggregatable: fieldFromBrowserField.aggregatable,
      isDraggable: isDraggable,
      isObjectArray: data.isObjectArray,
      value: value,
      linkValue: (_ref = getLinkValue && getLinkValue(data.field)) !== null && _ref !== void 0 ? _ref : linkValue,
      truncate: false
    }));
  }));
});
exports.FieldValueCell = FieldValueCell;
FieldValueCell.displayName = 'FieldValueCell';