"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldFromBrowserField = exports.getColumns = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _cell_actions = require("../cell_actions");
var i18n = _interopRequireWildcard(require("./translations"));
var _field_value_cell = require("./table/field_value_cell");
var _field_name_cell = require("./table/field_name_cell");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HoverActionsContainer = (0, _styledComponents.default)(_eui.EuiPanel)`
  align-items: center;
  display: flex;
  flex-direction: row;
  height: 25px;
  justify-content: center;
  left: 5px;
  position: absolute;
  top: -10px;
  width: 30px;
`;
HoverActionsContainer.displayName = 'HoverActionsContainer';
const getFieldFromBrowserField = (0, _memoizeOne.default)((keys, browserFields) => (0, _lodash.get)(browserFields, keys), (newArgs, lastArgs) => newArgs[0].join() === lastArgs[0].join());
exports.getFieldFromBrowserField = getFieldFromBrowserField;
const getColumns = ({
  browserFields,
  eventId,
  contextId,
  scopeId,
  getLinkValue,
  isDraggable,
  isReadOnly
}) => [...(!isReadOnly ? [{
  field: 'values',
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, i18n.ACTIONS)),
  sortable: false,
  truncateText: false,
  width: '132px',
  render: (values, data) => {
    const fieldFromBrowserField = getFieldFromBrowserField([data.category, 'fields', data.field], browserFields);
    return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
      field: {
        name: data.field,
        value: values,
        type: data.type,
        aggregatable: fieldFromBrowserField === null || fieldFromBrowserField === void 0 ? void 0 : fieldFromBrowserField.aggregatable
      },
      triggerId: _cell_actions.SecurityCellActionsTrigger.DETAILS_FLYOUT,
      mode: _cell_actions.CellActionsMode.INLINE,
      visibleCellActions: 3,
      metadata: {
        scopeId,
        isObjectArray: data.isObjectArray
      }
    });
  }
}] : []), {
  field: 'field',
  className: 'eventFieldsTable__fieldNameCell',
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, i18n.FIELD)),
  sortable: true,
  truncateText: false,
  render: (field, data) => {
    return /*#__PURE__*/_react.default.createElement(_field_name_cell.FieldNameCell, {
      data: data,
      field: field,
      fieldMapping: undefined
    });
  }
}, {
  field: 'values',
  className: 'eventFieldsTable__fieldValueCell',
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, i18n.VALUE)),
  sortable: true,
  truncateText: false,
  render: (values, data) => {
    const fieldFromBrowserField = getFieldFromBrowserField([data.category, 'fields', data.field], browserFields);
    return /*#__PURE__*/_react.default.createElement(_field_value_cell.FieldValueCell, {
      contextId: contextId,
      data: data,
      eventId: eventId,
      fieldFromBrowserField: fieldFromBrowserField,
      getLinkValue: getLinkValue,
      isDraggable: isDraggable,
      values: values
    });
  }
}];
exports.getColumns = getColumns;