"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointIsolateSuccess = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _translations = require("./translations");
var _use_cases_from_alerts = require("../../../../detections/containers/detection_engine/alerts/use_cases_from_alerts");
var _links = require("../../links");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CasesAdditionalInfo = ({
  alertIdForCase
}) => {
  const {
    casesInfo
  } = (0, _use_cases_from_alerts.useCasesFromAlerts)({
    alertId: alertIdForCase
  });
  const caseCount = (0, _react.useMemo)(() => casesInfo.length, [casesInfo]);
  const casesList = (0, _react.useMemo)(() => casesInfo.map((caseInfo, index) => {
    return /*#__PURE__*/_react.default.createElement("li", {
      key: caseInfo.id
    }, /*#__PURE__*/_react.default.createElement(_links.CaseDetailsLink, {
      detailName: caseInfo.id
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.hostIsolation.placeholderCase",
      defaultMessage: "{caseName}",
      values: {
        caseName: caseInfo.title
      }
    })));
  }), [casesInfo]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, caseCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.hostIsolation.successfulIsolation.cases",
    defaultMessage: "This action has been attached to the following {caseCount, plural, one {case} other {cases}}:",
    values: {
      caseCount
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("ul", null, casesList))));
};
const EndpointIsolateSuccess = /*#__PURE__*/(0, _react.memo)(({
  hostName,
  alertId,
  isolateAction = 'isolateHost',
  additionalInfo
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "check",
    color: "success",
    title: isolateAction === 'isolateHost' ? (0, _translations.GET_ISOLATION_SUCCESS_MESSAGE)(hostName) : (0, _translations.GET_UNISOLATION_SUCCESS_MESSAGE)(hostName),
    "data-test-subj": isolateAction === 'isolateHost' ? 'hostIsolateSuccessMessage' : 'hostUnisolateSuccessMessage'
  }, alertId !== undefined ? CasesAdditionalInfo({
    alertIdForCase: alertId
  }) : additionalInfo);
});
exports.EndpointIsolateSuccess = EndpointIsolateSuccess;
EndpointIsolateSuccess.displayName = 'EndpointIsolateSuccess';