"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CallOut = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _utility_types = require("../../../../common/utility_types");
var _callout_dismiss_button = require("./callout_dismiss_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CallOutComponent = ({
  message,
  iconType,
  dismissButtonText,
  onDismiss,
  showDismissButton = true
}) => {
  const {
    type,
    id,
    title,
    description
  } = message;
  const finalIconType = iconType !== null && iconType !== void 0 ? iconType : getDefaultIconType(type);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: type,
    title: title,
    iconType: finalIconType,
    "data-test-subj": `callout-${id}`,
    "data-test-messages": `[${id}]`
  }, description, showDismissButton && /*#__PURE__*/_react.default.createElement(_callout_dismiss_button.CallOutDismissButton, {
    message: message,
    text: dismissButtonText,
    onClick: onDismiss
  }));
};
const getDefaultIconType = type => {
  switch (type) {
    case 'primary':
      return 'iInCircle';
    case 'success':
      return 'cheer';
    case 'warning':
      return 'help';
    case 'danger':
      return 'warning';
    default:
      return (0, _utility_types.assertUnreachable)(type);
  }
};
const CallOut = /*#__PURE__*/(0, _react.memo)(CallOutComponent);
exports.CallOut = CallOut;