"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssistantAvailability = void 0;
var _use_license = require("../../common/hooks/use_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAssistantAvailability = () => {
  const isEnterprise = (0, _use_license.useLicense)().isEnterprise();
  return {
    isAssistantEnabled: isEnterprise,
    // TODO: RBAC check (https://github.com/elastic/security-team/issues/6932)
    // Leaving as a placeholder for RBAC as the same behavior will be required
    // When false, the Assistant is hidden and unavailable
    hasAssistantPrivilege: true
  };
};
exports.useAssistantAvailability = useAssistantAvailability;