"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFilterOutCellActionFactory = void 0;
var _cellActions = require("@kbn/cell-actions");
var _utils = require("../../utils");
var _timeline = require("../../../timelines/store/timeline");
var _types = require("../../../../common/types");
var _helpers = require("../../../helpers");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createFilterOutCellActionFactory = ({
  store,
  services
}) => {
  const getTimelineById = _timeline.timelineSelectors.getTimelineByIdSelector();
  const {
    filterManager
  } = services.data.query;
  const genericFilterOutActionFactory = (0, _cellActions.createFilterOutActionFactory)({
    filterManager
  });
  return genericFilterOutActionFactory.combine({
    type: _constants.SecurityCellActionType.FILTER,
    isCompatible: async ({
      field
    }) => (0, _utils.fieldHasCellActions)(field.name),
    execute: async ({
      field,
      metadata
    }) => {
      // if negateFilters is true we have to perform the opposite operation, we can just execute filterIn with the same params
      const addFilter = (metadata === null || metadata === void 0 ? void 0 : metadata.negateFilters) === true ? _cellActions.addFilterIn : _cellActions.addFilterOut;
      if (metadata !== null && metadata !== void 0 && metadata.scopeId && (0, _helpers.isTimelineScope)(metadata.scopeId)) {
        var _getTimelineById;
        const timelineFilterManager = (_getTimelineById = getTimelineById(store.getState(), _types.TimelineId.active)) === null || _getTimelineById === void 0 ? void 0 : _getTimelineById.filterManager;
        addFilter({
          filterManager: timelineFilterManager,
          fieldName: field.name,
          value: field.value
        });
      } else {
        addFilter({
          filterManager,
          fieldName: field.name,
          value: field.value
        });
      }
    }
  });
};
exports.createFilterOutCellActionFactory = createFilterOutCellActionFactory;