"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppFeatureSecurityKey = exports.AppFeatureKey = exports.AppFeatureCasesKey = exports.ALL_APP_FEATURE_KEYS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let AppFeatureSecurityKey;
exports.AppFeatureSecurityKey = AppFeatureSecurityKey;
(function (AppFeatureSecurityKey) {
  AppFeatureSecurityKey["advancedInsights"] = "advanced_insights";
  AppFeatureSecurityKey["endpointResponseActions"] = "endpoint_response_actions";
  AppFeatureSecurityKey["endpointExceptions"] = "endpoint_exceptions";
})(AppFeatureSecurityKey || (exports.AppFeatureSecurityKey = AppFeatureSecurityKey = {}));
let AppFeatureCasesKey; // Merges the two enums.
exports.AppFeatureCasesKey = AppFeatureCasesKey;
(function (AppFeatureCasesKey) {
  AppFeatureCasesKey["casesConnectors"] = "cases_connectors";
})(AppFeatureCasesKey || (exports.AppFeatureCasesKey = AppFeatureCasesKey = {}));
// We need to merge the value and the type and export both to replicate how enum works.
const AppFeatureKey = {
  ...AppFeatureSecurityKey,
  ...AppFeatureCasesKey
};
exports.AppFeatureKey = AppFeatureKey;
const ALL_APP_FEATURE_KEYS = Object.freeze(Object.values(AppFeatureKey));
exports.ALL_APP_FEATURE_KEYS = ALL_APP_FEATURE_KEYS;