"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RESPONSE_CONSOLE_ACTION_COMMANDS_TO_REQUIRED_AUTHZ = exports.RESPONSE_CONSOLE_ACTION_COMMANDS_TO_RBAC_FEATURE_CONTROL = exports.RESPONSE_CONSOLE_ACTION_COMMANDS_TO_ENDPOINT_CAPABILITY = exports.RESPONSE_ACTION_TYPE = exports.RESPONSE_ACTION_STATUS = exports.RESPONSE_ACTION_API_COMMANDS_TO_CONSOLE_COMMAND_MAP = exports.RESPONSE_ACTION_API_COMMANDS_NAMES = exports.ENDPOINT_CAPABILITIES = exports.ENABLED_AUTOMATED_RESPONSE_ACTION_COMMANDS = exports.DEFAULT_EXECUTE_ACTION_TIMEOUT = exports.CONSOLE_RESPONSE_ACTION_COMMANDS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RESPONSE_ACTION_STATUS = ['failed', 'pending', 'successful'];
exports.RESPONSE_ACTION_STATUS = RESPONSE_ACTION_STATUS;
const RESPONSE_ACTION_TYPE = ['automated', 'manual'];
exports.RESPONSE_ACTION_TYPE = RESPONSE_ACTION_TYPE;
/**
 * The Command names that are used in the API payload for the `{ command: '' }` attribute
 */
const RESPONSE_ACTION_API_COMMANDS_NAMES = ['isolate', 'unisolate', 'kill-process', 'suspend-process', 'running-processes', 'get-file', 'execute', 'upload'];
exports.RESPONSE_ACTION_API_COMMANDS_NAMES = RESPONSE_ACTION_API_COMMANDS_NAMES;
const ENABLED_AUTOMATED_RESPONSE_ACTION_COMMANDS = ['isolate'];
exports.ENABLED_AUTOMATED_RESPONSE_ACTION_COMMANDS = ENABLED_AUTOMATED_RESPONSE_ACTION_COMMANDS;
/**
 * The list of possible capabilities, reported by the endpoint in the metadata document
 */
const ENDPOINT_CAPABILITIES = ['isolation', 'kill_process', 'suspend_process', 'running_processes', 'get_file', 'execute', 'upload_file'];
exports.ENDPOINT_CAPABILITIES = ENDPOINT_CAPABILITIES;
/**
 * The list of possible console command names that generate a Response Action to be dispatched
 * to the Endpoint. (FYI: not all console commands are response actions)
 */
const CONSOLE_RESPONSE_ACTION_COMMANDS = ['isolate', 'release', 'kill-process', 'suspend-process', 'processes', 'get-file', 'execute', 'upload'];
exports.CONSOLE_RESPONSE_ACTION_COMMANDS = CONSOLE_RESPONSE_ACTION_COMMANDS;
/**
 * maps the console command to the RBAC control (kibana feature control) that is required to access it via console
 */
const RESPONSE_CONSOLE_ACTION_COMMANDS_TO_RBAC_FEATURE_CONTROL = Object.freeze({
  isolate: 'writeHostIsolation',
  release: 'writeHostIsolationRelease',
  'kill-process': 'writeProcessOperations',
  'suspend-process': 'writeProcessOperations',
  processes: 'writeProcessOperations',
  'get-file': 'writeFileOperations',
  execute: 'writeExecuteOperations',
  upload: 'writeFileOperations'
});
exports.RESPONSE_CONSOLE_ACTION_COMMANDS_TO_RBAC_FEATURE_CONTROL = RESPONSE_CONSOLE_ACTION_COMMANDS_TO_RBAC_FEATURE_CONTROL;
const RESPONSE_ACTION_API_COMMANDS_TO_CONSOLE_COMMAND_MAP = Object.freeze({
  isolate: 'isolate',
  unisolate: 'release',
  execute: 'execute',
  'get-file': 'get-file',
  'running-processes': 'processes',
  'kill-process': 'kill-process',
  'suspend-process': 'suspend-process',
  upload: 'upload'
});
exports.RESPONSE_ACTION_API_COMMANDS_TO_CONSOLE_COMMAND_MAP = RESPONSE_ACTION_API_COMMANDS_TO_CONSOLE_COMMAND_MAP;
const RESPONSE_CONSOLE_ACTION_COMMANDS_TO_ENDPOINT_CAPABILITY = Object.freeze({
  isolate: 'isolation',
  release: 'isolation',
  execute: 'execute',
  'get-file': 'get_file',
  processes: 'running_processes',
  'kill-process': 'kill_process',
  'suspend-process': 'suspend_process',
  upload: 'upload_file'
});

/**
 * The list of console commands mapped to the required EndpointAuthz to access that command
 */
exports.RESPONSE_CONSOLE_ACTION_COMMANDS_TO_ENDPOINT_CAPABILITY = RESPONSE_CONSOLE_ACTION_COMMANDS_TO_ENDPOINT_CAPABILITY;
const RESPONSE_CONSOLE_ACTION_COMMANDS_TO_REQUIRED_AUTHZ = Object.freeze({
  isolate: 'canIsolateHost',
  release: 'canUnIsolateHost',
  execute: 'canWriteExecuteOperations',
  'get-file': 'canWriteFileOperations',
  upload: 'canWriteFileOperations',
  processes: 'canGetRunningProcesses',
  'kill-process': 'canKillProcess',
  'suspend-process': 'canSuspendProcess'
});

// 4 hrs in seconds
// 4 * 60 * 60
exports.RESPONSE_CONSOLE_ACTION_COMMANDS_TO_REQUIRED_AUTHZ = RESPONSE_CONSOLE_ACTION_COMMANDS_TO_REQUIRED_AUTHZ;
const DEFAULT_EXECUTE_ACTION_TIMEOUT = 14400;
exports.DEFAULT_EXECUTE_ACTION_TIMEOUT = DEFAULT_EXECUTE_ACTION_TIMEOUT;