"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.insecureClusterAlertTitle = exports.insecureClusterAlertText = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const insecureClusterAlertTitle = _i18n.i18n.translate('xpack.security.checkup.insecureClusterTitle', {
  defaultMessage: 'Your data is not secure'
});
exports.insecureClusterAlertTitle = insecureClusterAlertTitle;
const insecureClusterAlertText = (docLinks, onDismiss) => e => {
  const AlertText = () => {
    const [persist, setPersist] = (0, _react.useState)(false);
    const enableSecurityDocLink = `${docLinks.links.security.elasticsearchEnableSecurity}?blade=kibanasecuritymessage`;
    return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "insecureClusterAlertText"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.checkup.insecureClusterMessage",
      defaultMessage: "Don\u2019t lose one bit. Enable our free security features."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: "persistDismissedAlertPreference",
      checked: persist,
      onChange: changeEvent => setPersist(changeEvent.target.checked),
      label: _i18n.i18n.translate('xpack.security.checkup.dontShowAgain', {
        defaultMessage: `Don't show again`
      })
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      color: "primary",
      fill: true,
      href: enableSecurityDocLink,
      target: "_blank",
      "data-test-subj": "learnMoreButton"
    }, _i18n.i18n.translate('xpack.security.checkup.enableButtonText', {
      defaultMessage: `Enable security`
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      onClick: () => onDismiss(persist),
      "data-test-subj": "dismissAlertButton"
    }, _i18n.i18n.translate('xpack.security.checkup.dismissButtonText', {
      defaultMessage: `Dismiss`
    }))))));
  };
  (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(AlertText, null), e);
  return () => (0, _reactDom.unmountComponentAtNode)(e);
};
exports.insecureClusterAlertText = insecureClusterAlertText;