"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityNavControl = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _userProfileComponents = require("@kbn/user-profile-components");
var _model = require("../../common/model");
var _components = require("../components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SecurityNavControl = ({
  editProfileUrl,
  logoutUrl,
  userMenuLinks$
}) => {
  const userMenuLinks = (0, _useObservable.default)(userMenuLinks$, []);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const userProfile = (0, _components.useUserProfile)('avatar');
  const currentUser = (0, _components.useCurrentUser)(); // User profiles do not exist for anonymous users so need to fetch current user as well

  const displayName = currentUser.value ? (0, _model.getUserDisplayName)(currentUser.value) : '';
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItemButton, {
    "aria-controls": "headerUserMenu",
    "aria-expanded": isPopoverOpen,
    "aria-haspopup": "true",
    "aria-label": _i18n.i18n.translate('xpack.security.navControlComponent.accountMenuAriaLabel', {
      defaultMessage: 'Account menu'
    }),
    onClick: () => setIsPopoverOpen(value => currentUser.value ? !value : false),
    "data-test-subj": "userMenuButton",
    style: {
      lineHeight: 'normal'
    }
  }, userProfile.value ? /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserAvatar, {
    user: userProfile.value.user,
    avatar: userProfile.value.data.avatar,
    size: "s",
    "data-test-subj": "userMenuAvatar"
  }) : currentUser.value && userProfile.error ? /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserAvatar, {
    user: currentUser.value,
    size: "s",
    "data-test-subj": "userMenuAvatar"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  }));
  const items = [];
  if (userMenuLinks.length) {
    const userMenuLinkMenuItems = userMenuLinks.sort(({
      order: orderA = Infinity
    }, {
      order: orderB = Infinity
    }) => orderA - orderB).map(({
      label,
      iconType,
      href
    }) => ({
      name: label,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: iconType,
        size: "m"
      }),
      href,
      'data-test-subj': `userMenuLink__${label}`
    }));
    items.push(...userMenuLinkMenuItems);
  }
  const isAnonymous = currentUser.value ? (0, _model.isUserAnonymous)(currentUser.value) : false;
  const hasCustomProfileLinks = userMenuLinks.some(({
    setAsProfile
  }) => setAsProfile === true);
  if (!isAnonymous && !hasCustomProfileLinks) {
    const profileMenuItem = {
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.navControlComponent.editProfileLinkText",
        defaultMessage: "Edit profile"
      }),
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "user",
        size: "m"
      }),
      href: editProfileUrl,
      onClick: () => {
        setIsPopoverOpen(false);
      },
      'data-test-subj': 'profileLink'
    };

    // Set this as the first link if there is no user-defined profile link
    items.unshift(profileMenuItem);
  }
  items.push({
    name: isAnonymous ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.navControlComponent.loginLinkText",
      defaultMessage: "Log in"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.navControlComponent.logoutLinkText",
      defaultMessage: "Log out"
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "exit",
      size: "m"
    }),
    href: logoutUrl,
    'data-test-subj': 'logoutLink'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "headerUserMenu",
    ownFocus: true,
    button: button,
    isOpen: isPopoverOpen,
    anchorPosition: "downRight",
    repositionOnScroll: true,
    closePopover: () => setIsPopoverOpen(false),
    panelPaddingSize: "none",
    buffer: 0
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "userMenu"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    className: "chrNavControl__userMenu",
    initialPanelId: 0,
    panels: [{
      id: 0,
      title: displayName,
      items
    }]
  })));
};
exports.SecurityNavControl = SecurityNavControl;