"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rolesManagementApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _breadcrumb = require("../../components/breadcrumb");
var _readonly_badge = require("../badges/readonly_badge");
var _url_utils = require("../url_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const rolesManagementApp = Object.freeze({
  id: 'roles',
  create({
    license,
    fatalErrors,
    getStartServices
  }) {
    const title = _i18n.i18n.translate('xpack.security.management.rolesTitle', {
      defaultMessage: 'Roles'
    });
    return {
      id: this.id,
      order: 20,
      title,
      async mount({
        element,
        theme$,
        setBreadcrumbs,
        history
      }) {
        const [[startServices, {
          dataViews,
          features,
          spaces
        }], {
          RolesGridPage
        }, {
          EditRolePage
        }, {
          RolesAPIClient
        }, {
          IndicesAPIClient
        }, {
          PrivilegesAPIClient
        }, {
          UserAPIClient
        }] = await Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./roles_grid'))), Promise.resolve().then(() => _interopRequireWildcard(require('./edit_role'))), Promise.resolve().then(() => _interopRequireWildcard(require('./roles_api_client'))), Promise.resolve().then(() => _interopRequireWildcard(require('./indices_api_client'))), Promise.resolve().then(() => _interopRequireWildcard(require('./privileges_api_client'))), Promise.resolve().then(() => _interopRequireWildcard(require('../users')))]);
        const {
          application,
          docLinks,
          http,
          i18n: i18nStart,
          notifications,
          chrome
        } = startServices;
        chrome.docTitle.change(title);
        const rolesAPIClient = new RolesAPIClient(http);
        const EditRolePageWithBreadcrumbs = ({
          action
        }) => {
          const {
            roleName
          } = (0, _reactRouterDom.useParams)();

          // Additional decoding is a workaround for a bug in react-router's version of the `history` module.
          // See https://github.com/elastic/kibana/issues/82440
          const decodedRoleName = roleName ? (0, _url_utils.tryDecodeURIComponent)(roleName) : undefined;
          const breadcrumbObj = action === 'edit' && roleName && decodedRoleName ? {
            text: decodedRoleName,
            href: `/edit/${encodeURIComponent(roleName)}`
          } : {
            text: _i18n.i18n.translate('xpack.security.roles.createBreadcrumb', {
              defaultMessage: 'Create'
            })
          };
          const spacesApiUi = spaces === null || spaces === void 0 ? void 0 : spaces.ui;
          return /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
            text: breadcrumbObj.text,
            href: breadcrumbObj.href
          }, /*#__PURE__*/_react.default.createElement(EditRolePage, {
            action: action,
            roleName: decodedRoleName,
            rolesAPIClient: rolesAPIClient,
            userAPIClient: new UserAPIClient(http),
            indicesAPIClient: new IndicesAPIClient(http),
            privilegesAPIClient: new PrivilegesAPIClient(http),
            getFeatures: features.getFeatures,
            http: http,
            notifications: notifications,
            fatalErrors: fatalErrors,
            license: license,
            docLinks: docLinks,
            uiCapabilities: application.capabilities,
            dataViews: dataViews,
            history: history,
            spacesApiUi: spacesApiUi
          }));
        };
        (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
          services: startServices
        }, /*#__PURE__*/_react.default.createElement(i18nStart.Context, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
          theme$: theme$
        }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
          history: history
        }, /*#__PURE__*/_react.default.createElement(_readonly_badge.ReadonlyBadge, {
          featureId: "roles",
          tooltip: _i18n.i18n.translate('xpack.security.management.roles.readonlyTooltip', {
            defaultMessage: 'Unable to create or edit roles'
          })
        }), /*#__PURE__*/_react.default.createElement(_breadcrumb.BreadcrumbsProvider, {
          onChange: (0, _breadcrumb.createBreadcrumbsChangeHandler)(chrome, setBreadcrumbs)
        }, /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
          text: title,
          href: "/"
        }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: ['/', ''],
          exact: true
        }, /*#__PURE__*/_react.default.createElement(RolesGridPage, {
          notifications: notifications,
          rolesAPIClient: rolesAPIClient,
          history: history,
          readOnly: !startServices.application.capabilities.roles.save
        })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: "/edit/:roleName?"
        }, /*#__PURE__*/_react.default.createElement(EditRolePageWithBreadcrumbs, {
          action: "edit"
        })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: "/clone/:roleName"
        }, /*#__PURE__*/_react.default.createElement(EditRolePageWithBreadcrumbs, {
          action: "clone"
        })))))))), element);
        return () => {
          (0, _reactDom.unmountComponentAtNode)(element);
        };
      }
    };
  }
});
exports.rolesManagementApp = rolesManagementApp;