"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegeDisplay = void 0;
var _eui = require("@elastic/eui");
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireDefault(require("react"));
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrivilegeDisplay = props => {
  return /*#__PURE__*/_react.default.createElement(SimplePrivilegeDisplay, props);
};
exports.PrivilegeDisplay = PrivilegeDisplay;
const SimplePrivilegeDisplay = props => {
  const {
    privilege,
    ...rest
  } = props;
  const text = /*#__PURE__*/_react.default.createElement(_eui.EuiText, rest, getDisplayValue(privilege));
  return text;
};
PrivilegeDisplay.defaultProps = {
  privilege: []
};
function getDisplayValue(privilege) {
  const privileges = coerceToArray(privilege);
  let displayValue;
  const isPrivilegeMissing = privileges.length === 0 || privileges.length === 1 && privileges.includes(_constants.NO_PRIVILEGE_VALUE);
  if (isPrivilegeMissing) {
    displayValue = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "subdued",
      type: 'minusInCircle'
    });
  } else {
    displayValue = privileges.map(p => _lodash.default.upperFirst(p)).join(', ');
  }
  return displayValue;
}
function coerceToArray(privilege) {
  if (privilege === undefined) {
    return [];
  }
  if (Array.isArray(privilege)) {
    return privilege;
  }
  return [privilege];
}