"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualRuleEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _model = require("../../model");
var _is_rule_group = require("../services/is_rule_group");
var _role_mapping_constants = require("../services/role_mapping_constants");
var _field_rule_editor = require("./field_rule_editor");
var _rule_group_editor = require("./rule_group_editor");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class VisualRuleEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "canUseVisualEditor", () => this.props.maxDepth < _role_mapping_constants.VISUAL_MAX_RULE_DEPTH);
    (0, _defineProperty2.default)(this, "getRuleDepthWarning", () => {
      if (this.canUseVisualEditor()) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        iconType: "warning",
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.visualRuleEditor.switchToJSONEditorTitle",
          defaultMessage: "Switch to JSON editor"
        }),
        "data-test-subj": "roleMappingsRulesTooComplex"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.visualRuleEditor.switchToJSONEditorMessage",
        defaultMessage: "Role mapping rules are too complex for the visual editor. Switch to the JSON editor to continue editing this rule."
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: this.props.onSwitchEditorMode,
        size: "s"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.visualRuleEditor.switchToJSONEditorButton",
        defaultMessage: "Use JSON editor"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }));
    });
    (0, _defineProperty2.default)(this, "onRuleChange", updatedRule => {
      this.props.onChange(updatedRule);
    });
    (0, _defineProperty2.default)(this, "onRuleDelete", () => {
      this.props.onChange(null);
    });
    (0, _defineProperty2.default)(this, "renderRule", (rule, onChange) => {
      return this.getEditorForRuleType(rule, onChange);
    });
  }
  render() {
    if (this.props.rules) {
      const rules = this.renderRule(this.props.rules, this.onRuleChange);
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, this.getRuleDepthWarning(), rules);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.visualRuleEditor.noRulesDefinedTitle",
        defaultMessage: "No rules defined"
      })),
      titleSize: "s",
      body: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.visualRuleEditor.noRulesDefinedMessage",
        defaultMessage: "Rules control which users should be assigned roles."
      })),
      "data-test-subj": "roleMappingsNoRulesDefined",
      actions: !this.props.readOnly && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "primary",
        iconType: "plusInCircle",
        "data-test-subj": "roleMappingsAddRuleButton",
        onClick: () => {
          this.props.onChange(new _model.AllRule([new _model.FieldRule('username', '*')]));
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.addFirstRuleButton",
        defaultMessage: "Add rules"
      }))
    });
  }
  getEditorForRuleType(rule, onChange) {
    if ((0, _is_rule_group.isRuleGroup)(rule)) {
      return /*#__PURE__*/_react.default.createElement(_rule_group_editor.RuleGroupEditor, {
        rule: rule,
        ruleDepth: 0,
        allowAdd: this.canUseVisualEditor(),
        onChange: value => onChange(value),
        onDelete: this.onRuleDelete,
        readOnly: this.props.readOnly
      });
    }
    return /*#__PURE__*/_react.default.createElement(_field_rule_editor.FieldRuleEditor, {
      rule: rule,
      onChange: value => onChange(value),
      onDelete: this.onRuleDelete,
      readOnly: this.props.readOnly
    });
  }
}
exports.VisualRuleEditor = VisualRuleEditor;
(0, _defineProperty2.default)(VisualRuleEditor, "defaultProps", {
  readOnly: false
});