"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedSearchPublicPlugin = void 0;
var _i18n = require("@kbn/i18n");
var _common = require("../common");
var _saved_searches_service = require("./services/saved_searches/saved_searches_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class SavedSearchPublicPlugin {
  setup(core, {
    contentManagement
  }) {
    contentManagement.registry.register({
      id: _common.SavedSearchType,
      version: {
        latest: _common.LATEST_VERSION
      },
      name: _i18n.i18n.translate('savedSearch.contentManagementType', {
        defaultMessage: 'Saved search'
      })
    });
    return {};
  }
  start(core, {
    data: {
      search
    },
    spaces,
    savedObjectsTaggingOss,
    contentManagement: {
      client: contentManagement
    }
  }) {
    return new _saved_searches_service.SavedSearchesService({
      search,
      spaces,
      savedObjectsTaggingOss,
      contentManagement
    });
  }
}
exports.SavedSearchPublicPlugin = SavedSearchPublicPlugin;