"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectTaggingPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _constants = require("../common/constants");
var _capabilities = require("../common/capabilities");
var _services = require("./services");
var _ui_api = require("./ui_api");
var _config = require("./config");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class SavedObjectTaggingPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "tagClient", void 0);
    (0, _defineProperty2.default)(this, "tagCache", void 0);
    (0, _defineProperty2.default)(this, "assignmentService", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    this.config = new _config.SavedObjectsTaggingClientConfig(context.config.get());
  }
  setup(core, {
    management,
    savedObjectsTaggingOss
  }) {
    const kibanaSection = management.sections.section.kibana;
    const title = _i18n.i18n.translate('xpack.savedObjectsTagging.management.sectionLabel', {
      defaultMessage: 'Tags'
    });
    kibanaSection.registerApp({
      id: _constants.tagManagementSectionId,
      title,
      order: 1.5,
      mount: async mountParams => {
        const {
          mountSection
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./management')));
        return mountSection({
          tagClient: this.tagClient,
          tagCache: this.tagCache,
          assignmentService: this.assignmentService,
          core,
          mountParams,
          title
        });
      }
    });
    savedObjectsTaggingOss.registerTaggingApi(core.getStartServices().then(([_core, _deps, startContract]) => startContract));
    return {};
  }
  start({
    http,
    application,
    overlays,
    theme
  }) {
    this.tagCache = new _services.TagsCache({
      refreshHandler: () => this.tagClient.getAll({
        asSystemRequest: true
      }),
      refreshInterval: this.config.cacheRefreshInterval
    });
    this.tagClient = new _services.TagsClient({
      http,
      changeListener: this.tagCache
    });
    this.assignmentService = new _services.TagAssignmentService({
      http
    });

    // do not fetch tags on anonymous page
    if (!http.anonymousPaths.isAnonymous(window.location.pathname)) {
      // we don't need to wait for this to resolve.
      this.tagCache.initialize().catch(() => {
        // cache is resilient to initial load failure. We just need to catch to avoid unhandled promise rejection
      });
    }
    return {
      client: this.tagClient,
      cache: this.tagCache,
      ui: (0, _ui_api.getUiApi)({
        cache: this.tagCache,
        client: this.tagClient,
        capabilities: (0, _capabilities.getTagsCapabilities)(application.capabilities),
        overlays,
        theme
      })
    };
  }
  stop() {
    if (this.tagCache) {
      this.tagCache.stop();
    }
  }
}
exports.SavedObjectTaggingPlugin = SavedObjectTaggingPlugin;