"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportModeControl = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createNewCopiesDisabled = {
  id: 'createNewCopiesDisabled',
  text: _i18n.i18n.translate('savedObjectsManagement.objectsTable.importModeControl.createNewCopies.disabledTitle', {
    defaultMessage: 'Check for existing objects'
  }),
  tooltip: _i18n.i18n.translate('savedObjectsManagement.objectsTable.importModeControl.createNewCopies.disabledText', {
    defaultMessage: 'Check if objects were previously copied or imported.'
  })
};
const createNewCopiesEnabled = {
  id: 'createNewCopiesEnabled',
  text: _i18n.i18n.translate('savedObjectsManagement.objectsTable.importModeControl.createNewCopies.enabledTitle', {
    defaultMessage: 'Create new objects with random IDs'
  }),
  tooltip: _i18n.i18n.translate('savedObjectsManagement.objectsTable.importModeControl.createNewCopies.enabledText', {
    defaultMessage: 'Use this option to create one or more copies of the object.'
  })
};
const overwriteEnabled = {
  id: 'overwriteEnabled',
  label: _i18n.i18n.translate('savedObjectsManagement.objectsTable.importModeControl.overwrite.enabledLabel', {
    defaultMessage: 'Automatically overwrite conflicts'
  })
};
const overwriteDisabled = {
  id: 'overwriteDisabled',
  label: _i18n.i18n.translate('savedObjectsManagement.objectsTable.importModeControl.overwrite.disabledLabel', {
    defaultMessage: 'Request action on conflict'
  })
};
const importOptionsTitle = _i18n.i18n.translate('savedObjectsManagement.objectsTable.importModeControl.importOptionsTitle', {
  defaultMessage: 'Import options'
});
const createLabel = ({
  text,
  tooltip
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, text)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  content: tooltip,
  position: "left",
  type: "iInCircle"
})));
const ImportModeControl = ({
  initialValues,
  updateSelection
}) => {
  const [createNewCopies, setCreateNewCopies] = (0, _react.useState)(initialValues.createNewCopies);
  const [overwrite, setOverwrite] = (0, _react.useState)(initialValues.overwrite);
  const onChange = partial => {
    if (partial.createNewCopies !== undefined) {
      setCreateNewCopies(partial.createNewCopies);
    } else if (partial.overwrite !== undefined) {
      setOverwrite(partial.overwrite);
    }
    updateSelection({
      createNewCopies,
      overwrite,
      ...partial
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
    legend: {
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement("span", null, importOptionsTitle))
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: createNewCopiesDisabled.id,
    label: createLabel(createNewCopiesDisabled),
    checked: !createNewCopies,
    onChange: () => onChange({
      createNewCopies: false
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: [overwriteEnabled, overwriteDisabled],
    idSelected: overwrite ? overwriteEnabled.id : overwriteDisabled.id,
    onChange: id => onChange({
      overwrite: id === overwriteEnabled.id
    }),
    disabled: createNewCopies,
    "data-test-subj": 'savedObjectsManagement-importModeControl-overwriteRadioGroup'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: createNewCopiesEnabled.id,
    label: createLabel(createNewCopiesEnabled),
    checked: createNewCopies,
    onChange: () => onChange({
      createNewCopies: true
    })
  }));
};
exports.ImportModeControl = ImportModeControl;