"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportingPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var Rx = _interopRequireWildcard(require("rxjs"));
var _operators = require("rxjs/operators");
var _public = require("@kbn/embeddable-plugin/public");
var _schema_utils = require("../common/schema_utils");
var _reporting_api_client = require("./lib/reporting_api_client");
var _stream_handler = require("./lib/stream_handler");
var _notifier = require("./notifier");
var _get_csv_panel_action = require("./panel_actions/get_csv_panel_action");
var _shared = require("./shared");
var _shared_imports = require("./shared_imports");
var _register_csv_reporting = require("./share_context_menu/register_csv_reporting");
var _register_pdf_png_reporting = require("./share_context_menu/register_pdf_png_reporting");
var _constants = require("../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function getStored() {
  const sessionValue = sessionStorage.getItem(_constants.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY);
  return sessionValue ? JSON.parse(sessionValue) : [];
}
function handleError(notifications, err, theme) {
  notifications.toasts.addDanger((0, _notifier.getGeneralErrorToast)(_i18n.i18n.translate('xpack.reporting.publicNotifier.pollingErrorMessage', {
    defaultMessage: 'Reporting notifier error!'
  }), err, theme));
  window.console.error(err);
  return Rx.of({
    completed: [],
    failed: []
  });
}
/**
 * @internal
 * @implements Plugin
 */
class ReportingPublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "apiClient", void 0);
    (0, _defineProperty2.default)(this, "stop$", new Rx.ReplaySubject(1));
    (0, _defineProperty2.default)(this, "title", _i18n.i18n.translate('xpack.reporting.management.reportingTitle', {
      defaultMessage: 'Reporting'
    }));
    (0, _defineProperty2.default)(this, "breadcrumbText", _i18n.i18n.translate('xpack.reporting.breadcrumb', {
      defaultMessage: 'Reporting'
    }));
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "contract", void 0);
    this.config = initializerContext.config.get();
    this.kibanaVersion = initializerContext.env.packageInfo.version;
  }

  /*
   * Use a single instance of ReportingAPIClient for all the reporting code
   */
  getApiClient(http, uiSettings) {
    if (!this.apiClient) {
      this.apiClient = new _reporting_api_client.ReportingAPIClient(http, uiSettings, this.kibanaVersion);
    }
    return this.apiClient;
  }
  getContract(core) {
    if (core) {
      this.contract = {
        usesUiCapabilities: () => {
          var _this$config$roles;
          return ((_this$config$roles = this.config.roles) === null || _this$config$roles === void 0 ? void 0 : _this$config$roles.enabled) === false;
        },
        components: (0, _shared.getSharedComponents)(core, this.getApiClient(core.http, core.uiSettings))
      };
    }
    if (!this.contract) {
      throw new Error(`Setup error in Reporting plugin!`);
    }
    return this.contract;
  }
  setup(core, setupDeps) {
    const {
      getStartServices,
      uiSettings
    } = core;
    const {
      home,
      management,
      screenshotMode,
      share,
      uiActions
    } = setupDeps;
    const startServices$ = Rx.from(getStartServices());
    const usesUiCapabilities = !this.config.roles.enabled;
    const apiClient = this.getApiClient(core.http, core.uiSettings);
    home.featureCatalogue.register({
      id: 'reporting',
      title: _i18n.i18n.translate('xpack.reporting.registerFeature.reportingTitle', {
        defaultMessage: 'Reporting'
      }),
      description: _i18n.i18n.translate('xpack.reporting.registerFeature.reportingDescription', {
        defaultMessage: 'Manage your reports generated from Discover, Visualize, and Dashboard.'
      }),
      icon: 'reportingApp',
      path: '/app/management/insightsAndAlerting/reporting',
      showOnHomePage: false,
      category: 'admin'
    });
    management.sections.section.insightsAndAlerting.registerApp({
      id: 'reporting',
      title: this.title,
      order: 3,
      mount: async params => {
        params.setBreadcrumbs([{
          text: this.breadcrumbText
        }]);
        const [[start, startDeps], {
          mountManagementSection
        }] = await Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./management/mount_management_section')))]);
        const {
          docTitle
        } = start.chrome;
        docTitle.change(this.title);
        const {
          license$
        } = startDeps.licensing;
        const umountAppCallback = await mountManagementSection(core, start, license$, this.config.poll, apiClient, share.url, params);
        return () => {
          docTitle.reset();
          umountAppCallback();
        };
      }
    });
    core.application.register({
      id: 'reportingRedirect',
      mount: async params => {
        const {
          mountRedirectApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./redirect')));
        return mountRedirectApp({
          ...params,
          apiClient,
          screenshotMode,
          share
        });
      },
      title: 'Reporting redirect app',
      searchable: false,
      chromeless: true,
      exactRoute: true,
      navLinkStatus: _shared_imports.AppNavLinkStatus.hidden
    });
    uiActions.addTriggerAction(_public.CONTEXT_MENU_TRIGGER, new _get_csv_panel_action.ReportingCsvPanelAction({
      core,
      apiClient,
      startServices$,
      usesUiCapabilities
    }));
    const reportingStart = this.getContract(core);
    const {
      toasts
    } = core.notifications;
    startServices$.subscribe(([{
      application
    }, {
      licensing
    }]) => {
      licensing.license$.subscribe(license => {
        share.register((0, _register_csv_reporting.reportingCsvShareProvider)({
          apiClient,
          toasts,
          uiSettings,
          license,
          application,
          usesUiCapabilities,
          theme: core.theme
        }));
        share.register((0, _register_pdf_png_reporting.reportingScreenshotShareProvider)({
          apiClient,
          toasts,
          uiSettings,
          license,
          application,
          usesUiCapabilities,
          theme: core.theme
        }));
      });
    });
    return reportingStart;
  }
  start(core) {
    const {
      notifications,
      docLinks
    } = core;
    const apiClient = this.getApiClient(core.http, core.uiSettings);
    const streamHandler = new _stream_handler.ReportingNotifierStreamHandler(notifications, apiClient, core.theme, docLinks);
    const interval = (0, _schema_utils.durationToNumber)(this.config.poll.jobsRefresh.interval);
    Rx.timer(0, interval).pipe((0, _operators.takeUntil)(this.stop$),
    // stop the interval when stop method is called
    (0, _operators.map)(() => getStored()),
    // read all pending job IDs from session storage
    (0, _operators.filter)(storedJobs => storedJobs.length > 0),
    // stop the pipeline here if there are none pending
    (0, _operators.mergeMap)(storedJobs => streamHandler.findChangedStatusJobs(storedJobs)),
    // look up the latest status of all pending jobs on the server
    (0, _operators.mergeMap)(({
      completed,
      failed
    }) => streamHandler.showNotifications({
      completed,
      failed
    })), (0, _operators.catchError)(err => handleError(notifications, err, core.theme))).subscribe();
    return this.getContract();
  }
  stop() {
    this.stop$.next();
  }
}
exports.ReportingPublicPlugin = ReportingPublicPlugin;