"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClustersUIPlugin = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../common/constants");
var _breadcrumb = require("./application/services/breadcrumb");
var _documentation = require("./application/services/documentation");
var _http = require("./application/services/http");
var _ui_metric = require("./application/services/ui_metric");
var _notification = require("./application/services/notification");
var _redirect = require("./application/services/redirect");
var _locator = require("./locator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class RemoteClustersUIPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
  }
  setup({
    notifications: {
      toasts
    },
    http,
    getStartServices
  }, {
    management,
    usageCollection,
    cloud,
    share
  }) {
    const {
      ui: {
        enabled: isRemoteClustersUiEnabled
      }
    } = this.initializerContext.config.get();
    if (isRemoteClustersUiEnabled) {
      const esSection = management.sections.section.data;
      esSection.registerApp({
        id: 'remote_clusters',
        title: _i18n.i18n.translate('xpack.remoteClusters.appTitle', {
          defaultMessage: 'Remote Clusters'
        }),
        order: 7,
        mount: async ({
          element,
          setBreadcrumbs,
          history,
          theme$
        }) => {
          var _cloud$baseUrl;
          const [core] = await getStartServices();
          const {
            chrome: {
              docTitle
            },
            i18n: {
              Context: i18nContext
            },
            docLinks,
            fatalErrors,
            executionContext
          } = core;
          docTitle.change(_constants.PLUGIN.getI18nName());

          // Initialize services
          (0, _breadcrumb.init)(setBreadcrumbs);
          (0, _documentation.init)(docLinks);
          (0, _ui_metric.init)(usageCollection);
          (0, _notification.init)(toasts, fatalErrors);
          (0, _http.init)(http);
          const isCloudEnabled = Boolean(cloud === null || cloud === void 0 ? void 0 : cloud.isCloudEnabled);
          const cloudBaseUrl = (_cloud$baseUrl = cloud === null || cloud === void 0 ? void 0 : cloud.baseUrl) !== null && _cloud$baseUrl !== void 0 ? _cloud$baseUrl : '';
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
          const unmountAppCallback = await renderApp(element, i18nContext, {
            isCloudEnabled,
            cloudBaseUrl,
            executionContext
          }, history, theme$);
          return () => {
            docTitle.reset();
            unmountAppCallback();
          };
        }
      });
      share.url.locators.create(new _locator.RemoteClustersLocatorDefinition({
        managementAppLocator: management.locator
      }));
    }
    return {
      isUiEnabled: isRemoteClustersUiEnabled
    };
  }
  start({
    application
  }) {
    const {
      ui: {
        enabled: isRemoteClustersUiEnabled
      }
    } = this.initializerContext.config.get();
    if (isRemoteClustersUiEnabled) {
      (0, _redirect.init)(application.navigateToApp);
    }
  }
  stop() {}
}
exports.RemoteClustersUIPlugin = RemoteClustersUIPlugin;