"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProfilingChartsTheme = useProfilingChartsTheme;
var _lodash = require("lodash");
var _use_profiling_dependencies = require("../components/contexts/profiling_dependencies/use_profiling_dependencies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const profilingTheme = {
  barSeriesStyle: {
    rectBorder: {
      strokeOpacity: 1,
      strokeWidth: 1,
      visible: true
    },
    rect: {
      opacity: 0.6
    }
  },
  scales: {
    barsPadding: 0,
    histogramPadding: 0
  }
};
function useProfilingChartsTheme() {
  const {
    start: {
      charts
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const chartsBaseTheme = charts.theme.useChartsBaseTheme();
  const chartsTheme = charts.theme.useChartsTheme();
  return {
    chartsBaseTheme,
    chartsTheme: (0, _lodash.merge)({}, chartsTheme, profilingTheme)
  };
}