"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfilingHeaderActionMenu = ProfilingHeaderActionMenu;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _use_profiling_router = require("../hooks/use_profiling_router");
var _no_data_view = require("../views/no_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ProfilingHeaderActionMenu() {
  const router = (0, _use_profiling_router.useProfilingRouter)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    href: router.link('/add-data-instructions', {
      query: {
        selectedTab: _no_data_view.NoDataTabs.Kubernetes
      }
    }),
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "indexOpen"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, _i18n.i18n.translate('xpack.profiling.headerActionMenu.addData', {
    defaultMessage: 'Add data'
  })))));
}