"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrimaryProfilingSearchBar = PrimaryProfilingSearchBar;
var _react = _interopRequireWildcard(require("react"));
var _use_profiling_params = require("../../hooks/use_profiling_params");
var _use_profiling_router = require("../../hooks/use_profiling_router");
var _use_profiling_route_path = require("../../hooks/use_profiling_route_path");
var _use_time_range_context = require("../../hooks/use_time_range_context");
var _use_profiling_dependencies = require("../contexts/profiling_dependencies/use_profiling_dependencies");
var _profiling_search_bar = require("./profiling_search_bar");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PrimaryProfilingSearchBar({
  showSubmitButton
}) {
  const {
    start: {
      data
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  const routePath = (0, _use_profiling_route_path.useProfilingRoutePath)();
  const {
    path,
    query
  } = (0, _use_profiling_params.useProfilingParams)('/*');
  if (!('rangeFrom' in query)) {
    throw new Error('Range query parameters are missing');
  }
  const {
    rangeFrom,
    rangeTo,
    kuery
  } = query;
  const {
    refresh
  } = (0, _use_time_range_context.useTimeRangeContext)();
  (0, _react.useEffect)(() => {
    // set time if both to and from are given in the url
    if (rangeFrom && rangeTo) {
      data.query.timefilter.timefilter.setTime({
        from: rangeFrom,
        to: rangeTo
      });
      return;
    }
  }, [rangeFrom, rangeTo, data]);
  return /*#__PURE__*/_react.default.createElement(_profiling_search_bar.ProfilingSearchBar, {
    kuery: kuery,
    rangeFrom: rangeFrom,
    rangeTo: rangeTo,
    onQuerySubmit: next => {
      var _next$query;
      profilingRouter.push(routePath, {
        path,
        query: {
          ...query,
          kuery: String(((_next$query = next.query) === null || _next$query === void 0 ? void 0 : _next$query.query) || ''),
          rangeFrom: next.dateRange.from,
          rangeTo: next.dateRange.to
        }
      });
    },
    onRefresh: nextDateRange => {
      profilingRouter.push(routePath, {
        path,
        query: {
          ...query,
          rangeFrom: nextDateRange.dateRange.from,
          rangeTo: nextDateRange.dateRange.to
        }
      });
    },
    onRefreshClick: () => {
      refresh();
    },
    showSubmitButton: showSubmitButton
  });
}