"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicensePrompt = LicensePrompt;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _url = _interopRequireDefault(require("url"));
var _use_profiling_dependencies = require("../contexts/profiling_dependencies/use_profiling_dependencies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KIBANA_LICENSE_MANAGEMENT_URL = '/app/management/stack/license_management';
function LicensePrompt() {
  const {
    core
  } = (0, _use_profiling_dependencies.useProfilingDependencies)().start;
  const manageLicenseURL = _url.default.format({
    pathname: core.http.basePath.prepend(KIBANA_LICENSE_MANAGEMENT_URL)
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "logoObservability",
    iconColor: "warning",
    title: /*#__PURE__*/_react.default.createElement("h1", null, _i18n.i18n.translate('xpack.profiling.invalidLicense.message', {
      defaultMessage: 'To access Universal Profiling, upgrade to an Enterprise subscription'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.profiling.invalidLicense.description', {
      defaultMessage: 'You must have an Enterprise subscription to use Universal Profiling features.'
    })),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      href: manageLicenseURL,
      fill: true
    }, _i18n.i18n.translate('xpack.profiling.invalidLicense.subscriptionManagementLink', {
      defaultMessage: 'Upgrade subscription'
    }))]
  });
}