"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInformationRows = getInformationRows;
var _i18n = require("@kbn/i18n");
var _common = require("../../../common");
var _profiling = require("../../../common/profiling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getInformationRows({
  fileID,
  frameType,
  exeFileName,
  addressOrLine,
  functionName,
  sourceFileName,
  sourceLine
}) {
  const executable = fileID === '' && addressOrLine === 0 ? 'root' : exeFileName;
  const sourceLineNumber = sourceLine > 0 ? `#${sourceLine}` : '';
  const informationRows = [];
  if (executable) {
    informationRows.push({
      label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.executableLabel', {
        defaultMessage: 'Executable'
      }),
      value: executable
    });
  } else {
    informationRows.push({
      label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.frameTypeLabel', {
        defaultMessage: 'Frame type'
      }),
      value: (0, _profiling.describeFrameType)(frameType)
    });
  }
  informationRows.push({
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.functionLabel', {
      defaultMessage: 'Function'
    }),
    value: functionName || _common.NOT_AVAILABLE_LABEL
  });
  informationRows.push({
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.sourceFileLabel', {
      defaultMessage: 'Source file'
    }),
    value: sourceFileName ? `${sourceFileName}${sourceLineNumber}` : _common.NOT_AVAILABLE_LABEL
  });
  return informationRows;
}