"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getImpactRows = getImpactRows;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _calculate_impact_estimates = require("../../utils/calculate_impact_estimates");
var _as_cost = require("../../utils/formatters/as_cost");
var _as_duration = require("../../utils/formatters/as_duration");
var _as_number = require("../../utils/formatters/as_number");
var _as_percentage = require("../../utils/formatters/as_percentage");
var _as_weight = require("../../utils/formatters/as_weight");
var _cpu_label_with_hint = require("../cpu_label_with_hint");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getImpactRows({
  countInclusive,
  countExclusive,
  totalSamples,
  totalSeconds,
  isApproximate = false
}) {
  const {
    percentage,
    percentageNoChildren,
    coreSeconds,
    annualizedCoreSeconds,
    coreSecondsNoChildren,
    co2,
    co2NoChildren,
    annualizedCo2,
    annualizedCo2NoChildren,
    dollarCost,
    dollarCostNoChildren,
    annualizedDollarCost,
    annualizedDollarCostNoChildren,
    annualizedCoreSecondsNoChildren
  } = (0, _calculate_impact_estimates.calculateImpactEstimates)({
    countInclusive,
    countExclusive,
    totalSamples,
    totalSeconds
  });
  const impactRows = [{
    label: /*#__PURE__*/_react.default.createElement(_cpu_label_with_hint.CPULabelWithHint, {
      type: "total",
      labelSize: "s",
      iconSize: "s"
    }),
    value: (0, _as_percentage.asPercentage)(percentage)
  }, {
    label: /*#__PURE__*/_react.default.createElement(_cpu_label_with_hint.CPULabelWithHint, {
      type: "self",
      labelSize: "s",
      iconSize: "s"
    }),
    value: (0, _as_percentage.asPercentage)(percentageNoChildren)
  }, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.samplesInclusiveLabel', {
      defaultMessage: 'Samples'
    }),
    value: (0, _as_number.asNumber)(countInclusive)
  }, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.samplesExclusiveLabel', {
      defaultMessage: 'Samples (excl. children)'
    }),
    value: (0, _as_number.asNumber)(countExclusive)
  }, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.coreSecondsInclusiveLabel', {
      defaultMessage: 'Core-seconds'
    }),
    value: (0, _as_duration.asDuration)(coreSeconds)
  }, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.coreSecondsExclusiveLabel', {
      defaultMessage: 'Core-seconds (excl. children)'
    }),
    value: (0, _as_duration.asDuration)(coreSecondsNoChildren)
  }, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.annualizedCoreSecondsInclusiveLabel', {
      defaultMessage: 'Annualized core-seconds'
    }),
    value: (0, _as_duration.asDuration)(annualizedCoreSeconds)
  }, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.annualizedCoreSecondsExclusiveLabel', {
      defaultMessage: 'Annualized core-seconds (excl. children)'
    }),
    value: (0, _as_duration.asDuration)(annualizedCoreSecondsNoChildren)
  }, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.co2EmissionInclusiveLabel', {
      defaultMessage: 'CO2 emission'
    }),
    value: (0, _as_weight.asWeight)(co2)
  }, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.co2EmissionExclusiveLabel', {
      defaultMessage: 'CO2 emission (excl. children)'
    }),
    value: (0, _as_weight.asWeight)(co2NoChildren)
  }, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.annualizedCo2InclusiveLabel', {
      defaultMessage: 'Annualized CO2'
    }),
    value: (0, _as_weight.asWeight)(annualizedCo2)
  }, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.annualizedCo2ExclusiveLabel', {
      defaultMessage: 'Annualized CO2 (excl. children)'
    }),
    value: (0, _as_weight.asWeight)(annualizedCo2NoChildren)
  }, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.dollarCostInclusiveLabel', {
      defaultMessage: 'Dollar cost'
    }),
    value: (0, _as_cost.asCost)(dollarCost)
  }, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.dollarCostExclusiveLabel', {
      defaultMessage: 'Dollar cost (excl. children)'
    }),
    value: (0, _as_cost.asCost)(dollarCostNoChildren)
  }, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.annualizedDollarCostInclusiveLabel', {
      defaultMessage: 'Annualized dollar cost'
    }),
    value: (0, _as_cost.asCost)(annualizedDollarCost)
  }, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.annualizedDollarCostExclusiveLabel', {
      defaultMessage: 'Annualized dollar cost (excl. children)'
    }),
    value: (0, _as_cost.asCost)(annualizedDollarCostNoChildren)
  }];
  return impactRows;
}