"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AsyncComponent = AsyncComponent;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_async = require("../hooks/use_async");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AsyncComponent({
  children,
  status,
  error,
  mono,
  size,
  style,
  alignTop
}) {
  if (status === _use_async.AsyncStatus.Settled && !error) {
    return children;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: alignTop ? 'flexStart' : 'center',
    justifyContent: "center",
    direction: "row",
    style: style,
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      alignContent: 'center'
    }
  }, error && status === _use_async.AsyncStatus.Settled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    color: "warning"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    style: {
      whiteSpace: 'nowrap'
    }
  }, _i18n.i18n.translate('xpack.profiling.asyncComponent.errorLoadingData', {
    defaultMessage: 'Could not load data'
  })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    mono: mono,
    size: size
  })));
}