"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.areResourcesSetup = areResourcesSetup;
exports.createDefaultSetupState = createDefaultSetupState;
exports.mergePartialSetupStates = mergePartialSetupStates;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createDefaultSetupState() {
  return {
    cloud: {
      available: false,
      required: true
    },
    data: {
      available: false
    },
    packages: {
      installed: false
    },
    permissions: {
      configured: false
    },
    policies: {
      apm: {
        installed: false
      },
      collector: {
        installed: false
      },
      symbolizer: {
        installed: false
      }
    },
    resource_management: {
      enabled: false
    },
    resources: {
      created: false
    },
    settings: {
      configured: false
    }
  };
}
function areResourcesSetup(state) {
  return state.resource_management.enabled && state.resources.created && state.packages.installed && state.permissions.configured && state.policies.apm.installed && state.policies.collector.installed && state.policies.symbolizer.installed && state.settings.configured;
}
function mergeRecursivePartial(base, partial) {
  return (0, _lodash.merge)(base, partial);
}
function mergePartialSetupStates(base, partials) {
  return partials.reduce(mergeRecursivePartial, base);
}