"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardsServiceFactory = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// TODO (clint): Create set of dashboards to stub and return.

function sleep(ms) {
  return new Promise(resolve => setTimeout(resolve, ms));
}
const dashboardsServiceFactory = () => ({
  findDashboards: async (query = '', _fields = []) => {
    if (!query) {
      return [];
    }
    await sleep(2000);
    return [];
  },
  findDashboardsByTitle: async title => {
    if (!title) {
      return [];
    }
    await sleep(2000);
    return [];
  }
});
exports.dashboardsServiceFactory = dashboardsServiceFactory;