"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardPicker = DashboardPicker;
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _services = require("../services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function DashboardPicker(props) {
  const [dashboardOptions, setDashboardOptions] = (0, _react.useState)([]);
  const [isLoadingDashboards, setIsLoadingDashboards] = (0, _react.useState)(true);
  const [selectedDashboard, setSelectedDashboard] = (0, _react.useState)(null);
  const [query, setQuery] = (0, _react.useState)('');
  const {
    isDisabled,
    onChange
  } = props;
  const {
    dashboards
  } = _services.pluginServices.getHooks();
  const {
    findDashboardsByTitle
  } = dashboards.useService();
  (0, _react.useEffect)(() => {
    // We don't want to manipulate the React state if the component has been unmounted
    // while we wait for the saved objects to return.
    let cleanedUp = false;
    const fetchDashboards = async () => {
      setIsLoadingDashboards(true);
      setDashboardOptions([]);
      const objects = await findDashboardsByTitle(query ? `${query}*` : '');
      if (cleanedUp) {
        return;
      }
      if (objects) {
        setDashboardOptions(objects.filter(d => !props.idsToOmit || !props.idsToOmit.includes(d.id)).map(d => ({
          value: d.id,
          label: d.attributes.title,
          'data-test-subj': `dashboard-picker-option-${d.attributes.title.replaceAll(' ', '-')}`
        })));
      }
      setIsLoadingDashboards(false);
    };
    fetchDashboards();
    return () => {
      cleanedUp = true;
    };
  }, [findDashboardsByTitle, query, props.idsToOmit]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "dashboardPickerInput",
    placeholder: _i18n.i18n.translate('presentationUtil.dashboardPicker.searchDashboardPlaceholder', {
      defaultMessage: 'Search dashboards...'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: dashboardOptions || [],
    selectedOptions: !!selectedDashboard ? [selectedDashboard] : undefined,
    onChange: e => {
      if (e.length) {
        setSelectedDashboard({
          value: e[0].value || '',
          label: e[0].label
        });
        onChange({
          name: e[0].label,
          id: e[0].value || ''
        });
      } else {
        setSelectedDashboard(null);
        onChange(null);
      }
    },
    onSearchChange: setQuery,
    isDisabled: isDisabled,
    isLoading: isLoadingDashboards,
    compressed: true
  });
}

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
var _default = DashboardPicker;
exports.default = _default;