"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.OsqueryActionResults = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _empty_prompt = require("../../routes/components/empty_prompt");
var _kibana = require("../../common/lib/kibana");
var _query_client = require("../../query_client");
var _shared_imports = require("../../shared_imports");
var _osquery_result = require("./osquery_result");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OsqueryActionResultsComponent = ({
  ruleName,
  actionItems,
  ecsData
}) => {
  const {
    read
  } = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  return !read ? /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, null) : /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": 'osquery-results'
  }, actionItems === null || actionItems === void 0 ? void 0 : actionItems.map(item => {
    var _item$fields, _item$fields$action_i, _item$fields2, _item$fields2$queries, _item$fields3;
    const actionId = (_item$fields = item.fields) === null || _item$fields === void 0 ? void 0 : (_item$fields$action_i = _item$fields.action_id) === null || _item$fields$action_i === void 0 ? void 0 : _item$fields$action_i[0];
    const queryId = (_item$fields2 = item.fields) === null || _item$fields2 === void 0 ? void 0 : (_item$fields2$queries = _item$fields2['queries.action_id']) === null || _item$fields2$queries === void 0 ? void 0 : _item$fields2$queries[0];
    const startDate = (_item$fields3 = item.fields) === null || _item$fields3 === void 0 ? void 0 : _item$fields3['@timestamp'][0];
    return /*#__PURE__*/_react.default.createElement(_osquery_result.OsqueryResult, {
      key: actionId,
      actionId: actionId,
      queryId: queryId,
      startDate: startDate,
      ruleName: ruleName,
      ecsData: ecsData
    });
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
};
const OsqueryActionResults = /*#__PURE__*/_react.default.memo(OsqueryActionResultsComponent);
exports.OsqueryActionResults = OsqueryActionResults;
const OsqueryActionResultsWrapperComponent = ({
  services,
  ...restProps
}) => /*#__PURE__*/_react.default.createElement(_shared_imports.KibanaThemeProvider, {
  theme$: services.theme.theme$
}, /*#__PURE__*/_react.default.createElement(_kibana.KibanaContextProvider, {
  services: services
}, /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
  client: _query_client.queryClient
}, /*#__PURE__*/_react.default.createElement(OsqueryActionResults, restProps)))));
const OsqueryActionResultsWrapper = /*#__PURE__*/_react.default.memo(OsqueryActionResultsWrapperComponent);

// eslint-disable-next-line import/no-default-export
exports.default = OsqueryActionResultsWrapper;