"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryResult = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_live_query_details = require("../../actions/use_live_query_details");
var _translations = require("../../agents/translations");
var _pack_queries_status_table = require("../../live_queries/form/pack_queries_status_table");
var _contexts = require("../../common/contexts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OsqueryResult = /*#__PURE__*/_react.default.memo(({
  actionId,
  ruleName,
  startDate,
  ecsData
}) => {
  const [isLive, setIsLive] = (0, _react.useState)(false);
  const {
    data
  } = (0, _use_live_query_details.useLiveQueryDetails)({
    actionId,
    isLive
  });
  (0, _react.useLayoutEffect)(() => {
    setIsLive(() => !((data === null || data === void 0 ? void 0 : data.status) === 'completed'));
  }, [data === null || data === void 0 ? void 0 : data.status]);
  return /*#__PURE__*/_react.default.createElement(_contexts.AlertAttachmentContext.Provider, {
    value: ecsData
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiComment, {
    username: ruleName,
    timestamp: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
      value: startDate
    }),
    event: _translations.ATTACHED_QUERY,
    "data-test-subj": 'osquery-results-comment'
  }, /*#__PURE__*/_react.default.createElement(_pack_queries_status_table.PackQueriesStatusTable, {
    actionId: actionId,
    data: data === null || data === void 0 ? void 0 : data.queries,
    startDate: data === null || data === void 0 ? void 0 : data['@timestamp'],
    expirationDate: data === null || data === void 0 ? void 0 : data.expiration,
    agentIds: data === null || data === void 0 ? void 0 : data.agents
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
});
exports.OsqueryResult = OsqueryResult;