"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSavedQueries = void 0;
var _reactQuery = require("@tanstack/react-query");
var _kibana = require("../common/lib/kibana");
var _use_error_toast = require("../common/hooks/use_error_toast");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSavedQueries = ({
  isLive = false,
  pageIndex = 0,
  pageSize = 10000,
  sortField = 'updated_at',
  sortOrder = 'desc'
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  return (0, _reactQuery.useQuery)([_constants.SAVED_QUERIES_ID, {
    pageIndex,
    pageSize,
    sortField,
    sortOrder
  }], () => http.get('/api/osquery/saved_queries', {
    query: {
      page: pageIndex + 1,
      pageSize,
      sort: sortField,
      sortOrder
    }
  }), {
    keepPreviousData: true,
    refetchInterval: isLive ? 10000 : false,
    onError: error => {
      setErrorToast(error, {
        title: error.body.error,
        toastMessage: error.body.message
      });
    },
    refetchOnWindowFocus: !!isLive
  });
};
exports.useSavedQueries = useSavedQueries;