"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedQueryFlyout = void 0;
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_saved_query_form = require("./form/use_saved_query_form");
var _form = require("./form");
var _use_create_saved_query = require("./use_create_saved_query");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const additionalZIndexStyle = {
  style: 'z-index: 6000'
};
const SavedQueryFlyoutComponent = ({
  defaultValue,
  onClose,
  isExternal
}) => {
  const createSavedQueryMutation = (0, _use_create_saved_query.useCreateSavedQuery)({
    withRedirect: false
  });
  const hooksForm = (0, _use_saved_query_form.useSavedQueryForm)({
    defaultValue
  });
  const {
    serializer,
    idSet,
    handleSubmit,
    formState: {
      isSubmitting
    }
  } = hooksForm;
  const onSubmit = (0, _react.useCallback)(async payload => {
    const serializedData = serializer(payload);
    await createSavedQueryMutation.mutateAsync(serializedData).then(() => onClose());
  }, [createSavedQueryMutation, onClose, serializer]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "data-test-subj": 'osquery-save-query-flyout',
    size: "m",
    ownFocus: true,
    onClose: onClose,
    "aria-labelledby": "flyoutTitle",
    maskProps: isExternal ? additionalZIndexStyle : undefined // For an edge case to display above the alerts flyout
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.savedQuery.saveQueryFlyoutForm.addFormTitle",
    defaultMessage: "Save query"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, hooksForm, /*#__PURE__*/_react.default.createElement(_form.SavedQueryForm, {
    idSet: idSet
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onClose,
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.pack.queryFlyoutForm.cancelButtonLabel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: isSubmitting,
    onClick: handleSubmit(onSubmit),
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.pack.queryFlyoutForm.saveButtonLabel",
    defaultMessage: "Save"
  })))))));
};
const SavedQueryFlyout = /*#__PURE__*/_react.default.memo(SavedQueryFlyoutComponent);
exports.SavedQueryFlyout = SavedQueryFlyout;