"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditSavedQueryPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _kibana = require("../../../common/lib/kibana");
var _layouts = require("../../../components/layouts");
var _use_breadcrumbs = require("../../../common/hooks/use_breadcrumbs");
var _form = require("./form");
var _saved_queries = require("../../../saved_queries");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiCallOut = (0, _styledComponents.default)(_eui.EuiCallOut)`
  margin: 10px;
`;
const EditSavedQueryPageComponent = () => {
  var _savedQueryDetails$sa;
  const permissions = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  const [isDeleteModalVisible, setIsDeleteModalVisible] = (0, _react.useState)(false);
  const {
    savedQueryId
  } = (0, _reactRouterDom.useParams)();
  const savedQueryListProps = (0, _kibana.useRouterNavigate)('saved_queries');
  const {
    isLoading,
    data: savedQueryDetails
  } = (0, _saved_queries.useSavedQuery)({
    savedQueryId
  });
  const updateSavedQueryMutation = (0, _saved_queries.useUpdateSavedQuery)({
    savedQueryId
  });
  const deleteSavedQueryMutation = (0, _saved_queries.useDeleteSavedQuery)({
    savedQueryId
  });
  (0, _use_breadcrumbs.useBreadcrumbs)('saved_query_edit', {
    savedQueryName: (_savedQueryDetails$sa = savedQueryDetails === null || savedQueryDetails === void 0 ? void 0 : savedQueryDetails.saved_object_id) !== null && _savedQueryDetails$sa !== void 0 ? _savedQueryDetails$sa : ''
  });
  const elasticPrebuiltQuery = (0, _react.useMemo)(() => !!(savedQueryDetails !== null && savedQueryDetails !== void 0 && savedQueryDetails.prebuilt), [savedQueryDetails]);
  const viewMode = (0, _react.useMemo)(() => !permissions.writeSavedQueries || elasticPrebuiltQuery, [permissions.writeSavedQueries, elasticPrebuiltQuery]);
  const handleCloseDeleteConfirmationModal = (0, _react.useCallback)(() => {
    setIsDeleteModalVisible(false);
  }, []);
  const handleDeleteClick = (0, _react.useCallback)(() => {
    setIsDeleteModalVisible(true);
  }, []);
  const handleDeleteConfirmClick = (0, _react.useCallback)(() => {
    deleteSavedQueryMutation.mutateAsync().then(() => {
      handleCloseDeleteConfirmationModal();
    });
  }, [deleteSavedQueryMutation, handleCloseDeleteConfirmationModal]);
  const LeftColumn = (0, _react.useMemo)(() => {
    var _savedQueryDetails$id, _savedQueryDetails$id2;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "flexStart",
      direction: "column",
      gutterSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
      iconType: "arrowLeft"
    }, savedQueryListProps, {
      flush: "left",
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.editSavedQuery.viewSavedQueriesListTitle",
      defaultMessage: "View all saved queries"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h1", null, viewMode ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.viewSavedQuery.pageTitle",
      defaultMessage: "\"{savedQueryId}\" details"
      // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
      ,
      values: {
        savedQueryId: (_savedQueryDetails$id = savedQueryDetails === null || savedQueryDetails === void 0 ? void 0 : savedQueryDetails.id) !== null && _savedQueryDetails$id !== void 0 ? _savedQueryDetails$id : ''
      }
    }), elasticPrebuiltQuery && /*#__PURE__*/_react.default.createElement(StyledEuiCallOut, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.viewSavedQuery.prebuiltInfo",
      defaultMessage: "This is a prebuilt Elastic query, and it cannot be edited."
    }))) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.editSavedQuery.pageTitle",
      defaultMessage: "Edit \"{savedQueryId}\""
      // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
      ,
      values: {
        savedQueryId: (_savedQueryDetails$id2 = savedQueryDetails === null || savedQueryDetails === void 0 ? void 0 : savedQueryDetails.id) !== null && _savedQueryDetails$id2 !== void 0 ? _savedQueryDetails$id2 : ''
      }
    })))));
  }, [elasticPrebuiltQuery, savedQueryDetails === null || savedQueryDetails === void 0 ? void 0 : savedQueryDetails.id, savedQueryListProps, viewMode]);
  const RightColumn = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    onClick: handleDeleteClick,
    iconType: "trash"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.editSavedQuery.deleteSavedQueryButtonLabel",
    defaultMessage: "Delete query"
  })), [handleDeleteClick]);
  const handleSubmit = (0, _react.useCallback)(async payload => {
    await updateSavedQueryMutation.mutateAsync(payload);
  }, [updateSavedQueryMutation]);
  if (isLoading) return null;
  return /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    leftColumn: LeftColumn,
    rightColumn: !viewMode ? RightColumn : undefined,
    rightColumnGrow: false
  }, !isLoading && !(0, _fp.isEmpty)(savedQueryDetails) && /*#__PURE__*/_react.default.createElement(_form.EditSavedQueryForm, {
    defaultValue: savedQueryDetails,
    handleSubmit: handleSubmit,
    viewMode: viewMode
  }), isDeleteModalVisible ? /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.deleteSavedQuery.confirmationModal.title",
      defaultMessage: "Are you sure you want to delete this query?"
    }),
    onCancel: handleCloseDeleteConfirmationModal,
    onConfirm: handleDeleteConfirmClick,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.deleteSavedQuery.confirmationModal.cancelButtonLabel",
      defaultMessage: "Cancel"
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.deleteSavedQuery.confirmationModal.confirmButtonLabel",
      defaultMessage: "Confirm"
    }),
    buttonColor: "danger",
    defaultFocusedButton: "confirm"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.deleteSavedQuery.confirmationModal.body",
    defaultMessage: "You're about to delete this query. Are you sure you want to do this?"
  })) : null);
};
const EditSavedQueryPage = /*#__PURE__*/_react.default.memo(EditSavedQueryPageComponent);
exports.EditSavedQueryPage = EditSavedQueryPage;