"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertSOQueriesToPack = exports.convertPackQueriesToSO = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertPackQueriesToSO = queries => (0, _lodash.reduce)(queries, (acc, value, key) => {
  acc.push({
    id: key,
    ...(0, _lodash.pick)(value, ['query', 'interval', 'snapshot', 'removed', 'platform', 'version', 'ecs_mapping'])
  });
  return acc;
}, []);
exports.convertPackQueriesToSO = convertPackQueriesToSO;
const convertSOQueriesToPack = queries => (0, _lodash.reduce)(queries, (acc, {
  id: queryId,
  ...query
}) => {
  acc[queryId] = query;
  return acc;
}, {});
exports.convertSOQueriesToPack = convertSOQueriesToPack;