"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLiveQueryDetails = void 0;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _kibana = require("../common/lib/kibana");
var _use_error_toast = require("../common/hooks/use_error_toast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLiveQueryDetails = ({
  actionId,
  filterQuery,
  isLive = false,
  skip = false,
  queryIds // enable finding out specific queries only, eg. in cases
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  return (0, _reactQuery.useQuery)(['liveQueries', {
    actionId,
    filterQuery,
    queryIds
  }], () => http.get(`/api/osquery/live_queries/${actionId}`), {
    enabled: !skip && !!actionId,
    refetchInterval: isLive ? 5000 : false,
    onSuccess: () => setErrorToast(),
    onError: error => setErrorToast(error, {
      title: _i18n.i18n.translate('xpack.osquery.action_details.fetchError', {
        defaultMessage: 'Error while fetching action details'
      })
    }),
    select: response => {
      if (queryIds) {
        const filteredQueries = (0, _lodash.filter)(response.data.queries, query => queryIds.includes(query.action_id));
        return {
          ...response.data,
          queries: filteredQueries
        };
      }
      return response.data;
    },
    refetchOnWindowFocus: false,
    retryDelay: 5000
  });
};
exports.useLiveQueryDetails = useLiveQueryDetails;